/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.quality_report.slides.DiffInfo;
import com.teamscale.index.quality_report.slides.FindingDetailSlide;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SelfContainedFinding;
import com.teamscale.index.quality_report.slides.WrappedLogEntry;
import com.teamscale.index.repository.RepositoryLastChangeUtils;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.reports.ReportSlideWithRenderData;
import com.teamscale.service.reports.slides.ReportUtils;
import com.teamscale.service.reports.slides.SlideRenderContext;
import com.teamscale.service.reports.slides.SlideRendererBase;
import com.teamscale.service.resource.TokenElementServiceUtils;
import com.teamscale.service.user.UserResolveUtils;
import com.teamscale.service.user.UserResolvedRepositoryLogEntry;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.diff.DiffDescription;
import org.conqat.lib.commons.diff.LineBasedDiffer;
import org.conqat.lib.commons.diff.RegionDiffer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class FindingsDetailSlideRenderer
extends SlideRendererBase<FindingDetailSlide.FindingDetailSlideParameters> {
    public FindingsDetailSlideRenderer(SlideRenderContext<FindingDetailSlide.FindingDetailSlideParameters> slideRenderContext) {
        super(slideRenderContext);
    }

    public FindingDetailSlide.FindingDetailSlideResult createSlideResult(@Nullable ReportSlideWithRenderData existingSlide) throws StorageException {
        ProjectBranchPath projectBranchPath = ((FindingDetailSlide.FindingDetailSlideParameters)this.getParameters()).getProjectBranchPath();
        IStorageInfo projectStorageInfo = this.renderContext.resolveProjectAndReturnLocalStorageInfo(projectBranchPath);
        UnresolvedCommitDescriptor unresolvedCommit = ReportUtils.buildCommit(projectBranchPath.getBranch(), DateTimeUtils.millisNow());
        CommitDescriptor commitOnBranchAtHead = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)unresolvedCommit, () -> ((IStorageInfo)projectStorageInfo).getProjectStorageSystem());
        HistoryAccessOption accessAtBranchHead = HistoryAccessOption.readTimestamp((String)commitOnBranchAtHead.getBranchName(), (long)commitOnBranchAtHead.getTimestamp());
        TrackedFindingsByIdIndex findingsIndex = (TrackedFindingsByIdIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(TrackedFindingsByIdIndex.class, accessAtBranchHead);
        String findingId = ((FindingDetailSlide.FindingDetailSlideParameters)this.getParameters()).getFindingId();
        TrackedFinding trackedFinding = null;
        if (findingId != null) {
            trackedFinding = findingsIndex.getFinding(findingId);
        }
        if (trackedFinding == null) {
            return new FindingDetailSlide.FindingDetailSlideResult(null, null, commitOnBranchAtHead, null, new FindingDetailSlide.CodeRange("", ""), null, this.getSlideCommentRenderData(((FindingDetailSlide.FindingDetailSlideParameters)this.getParameters()).getProjectBranchPath(), ((FindingDetailSlide.FindingDetailSlideParameters)this.getParameters()).getComments()));
        }
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(CommitDescriptorIndex.class, null);
        if (!trackedFinding.isAlive()) {
            CommitDescriptor previousCommit = UnresolvedCommitDescriptorUtils.resolveParent((CommitDescriptor)trackedFinding.getDeathCommit(), (CommitDescriptorIndex)commitDescriptorIndex);
            accessAtBranchHead = HistoryAccessOption.readTimestamp((String)previousCommit.getBranchName(), (long)previousCommit.getTimestamp());
        }
        FormattedTokenElementInfo formattedContent = FindingsDetailSlideRenderer.loadCodeForUniformPath(trackedFinding.getLocation().getUniformPath(), projectStorageInfo, accessAtBranchHead);
        UserResolvedRepositoryLogEntry logEntry = this.loadIntroductionOrRemovalCommitLogEntry(projectStorageInfo, trackedFinding, commitDescriptorIndex);
        SelfContainedFinding selfContainedFinding = SelfContainedFinding.from((TrackedFinding)trackedFinding, (FormattedTokenElementInfo)formattedContent);
        DiffInfo diffInfo = null;
        String siblingId = ((FindingDetailSlide.FindingDetailSlideParameters)this.getParameters()).getSiblingId();
        if (siblingId != null && !siblingId.isEmpty()) {
            TrackedFinding trackedSiblingFinding = findingsIndex.getFinding(((FindingDetailSlide.FindingDetailSlideParameters)this.getParameters()).getSiblingId());
            FormattedTokenElementInfo siblingFormattedContent = FindingsDetailSlideRenderer.loadCodeForUniformPath(trackedSiblingFinding.getLocation().getUniformPath(), projectStorageInfo, accessAtBranchHead);
            diffInfo = this.loadCloneComparisonDiffInfo(trackedFinding, formattedContent, trackedSiblingFinding, siblingFormattedContent, new CommitDescriptor(accessAtBranchHead.getBranchName(), accessAtBranchHead.getTimestamp()), projectStorageInfo, commitDescriptorIndex);
        } else if (((FindingDetailSlide.FindingDetailSlideParameters)this.getParameters()).showIntroOrRemovalDiff()) {
            diffInfo = this.loadFindingIntroductionOrRemovalDiffInfo(trackedFinding, projectStorageInfo, commitDescriptorIndex);
        }
        return new FindingDetailSlide.FindingDetailSlideResult(selfContainedFinding, new WrappedLogEntry((RepositoryLogEntry)logEntry, logEntry.getResolvedAuthor()), commitOnBranchAtHead, siblingId, ((FindingDetailSlide.FindingDetailSlideParameters)this.getParameters()).getCodeRange(), diffInfo, this.getSlideCommentRenderData(((FindingDetailSlide.FindingDetailSlideParameters)this.getParameters()).getProjectBranchPath(), ((FindingDetailSlide.FindingDetailSlideParameters)this.getParameters()).getComments()));
    }

    private DiffInfo loadCloneComparisonDiffInfo(TrackedFinding trackedFinding, FormattedTokenElementInfo cloneFormattedContent, TrackedFinding trackedSiblingFinding, FormattedTokenElementInfo siblingFormattedContent, CommitDescriptor commit, IStorageInfo projectStorageInfo, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        if (cloneFormattedContent == null || siblingFormattedContent == null) {
            return null;
        }
        String regionDescription = FindingsDetailSlideRenderer.getRegionDescriptionForFinding(trackedFinding, trackedSiblingFinding);
        DiffDescription diffs = new RegionDiffer(regionDescription).performDiff((Object)cloneFormattedContent.getText(), (Object)siblingFormattedContent.getText());
        return this.computeDiffInfo(diffs, trackedFinding.getLocation().getUniformPath(), trackedFinding.getLocation().getUniformPath(), commit, commit, cloneFormattedContent, siblingFormattedContent, projectStorageInfo, commitDescriptorIndex);
    }

    private static String getRegionDescriptionForFinding(TrackedFinding trackedFinding, TrackedFinding siblingFinding) {
        int leftStart = ((TextRegionLocation)trackedFinding.getLocation()).getRawStartLine();
        int leftEnd = ((TextRegionLocation)trackedFinding.getLocation()).getRawEndLine();
        int rightStart = ((TextRegionLocation)siblingFinding.getLocation()).getRawStartLine();
        int rightEnd = ((TextRegionLocation)siblingFinding.getLocation()).getRawEndLine();
        return leftStart + "-" + leftEnd + ":" + rightStart + "-" + rightEnd;
    }

    private @Nullable DiffInfo loadFindingIntroductionOrRemovalDiffInfo(TrackedFinding finding, IStorageInfo projectStorageInfo, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        if (finding.getDeathCommit() == null) {
            return this.createIntroductionDiffInfo(finding, projectStorageInfo, commitDescriptorIndex);
        }
        return this.createRemovalDiffInfo(finding, projectStorageInfo, commitDescriptorIndex);
    }

    private @Nullable DiffInfo createRemovalDiffInfo(TrackedFinding finding, IStorageInfo projectStorageInfo, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        CommitDescriptor commitAtFindingRemoval = finding.getDeathCommit();
        return this.createDiffFromParentCommitTo(commitAtFindingRemoval, finding.getLocation().getUniformPath(), projectStorageInfo, commitDescriptorIndex);
    }

    private @Nullable DiffInfo createIntroductionDiffInfo(TrackedFinding finding, IStorageInfo projectStorageInfo, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        CommitDescriptor findingBirthCommit = finding.getBirthCommit();
        return this.createDiffFromParentCommitTo(findingBirthCommit, finding.getLocation().getUniformPath(), projectStorageInfo, commitDescriptorIndex);
    }

    private @Nullable DiffInfo createDiffFromParentCommitTo(CommitDescriptor toCommit, String uniformPath, IStorageInfo projectStorageInfo, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        ElementHistoryEntry historyElementAtPreviousCommit;
        CommitDescriptor previousCommit = UnresolvedCommitDescriptorUtils.resolveParent((CommitDescriptor)toCommit, (CommitDescriptorIndex)commitDescriptorIndex);
        ElementHistoryEntry historyElementAtToCommit = FindingsDetailSlideRenderer.getElementHistoryEntry(projectStorageInfo, toCommit, uniformPath);
        String uniformPathAtPreviousCommit = uniformPath;
        if (historyElementAtToCommit != null && historyElementAtToCommit.getOriginPath() != null) {
            uniformPathAtPreviousCommit = historyElementAtToCommit.getOriginPath();
        }
        if ((historyElementAtPreviousCommit = FindingsDetailSlideRenderer.getElementHistoryEntry(projectStorageInfo, previousCommit, uniformPathAtPreviousCommit)) == null) {
            return null;
        }
        previousCommit = historyElementAtPreviousCommit.getCommit();
        FormattedTokenElementInfo codeAtPreviousCommit = FindingsDetailSlideRenderer.loadCodeForUniformPath(uniformPathAtPreviousCommit, projectStorageInfo, HistoryAccessOption.readCommit((CommitDescriptor)previousCommit));
        FormattedTokenElementInfo codeAtToCommit = FindingsDetailSlideRenderer.loadCodeForUniformPath(uniformPath, projectStorageInfo, HistoryAccessOption.readCommit((CommitDescriptor)toCommit));
        if (codeAtPreviousCommit == null || codeAtToCommit == null) {
            return null;
        }
        DiffDescription diffs = new LineBasedDiffer(false).performDiff((Object)codeAtPreviousCommit.getText(), (Object)codeAtToCommit.getText());
        return this.computeDiffInfo(diffs, uniformPathAtPreviousCommit, uniformPath, previousCommit, toCommit, codeAtPreviousCommit, codeAtToCommit, projectStorageInfo, commitDescriptorIndex);
    }

    private DiffInfo computeDiffInfo(DiffDescription diffs, String leftUniformPath, String rightUniformPath, CommitDescriptor leftCommit, CommitDescriptor rightCommit, FormattedTokenElementInfo leftContent, FormattedTokenElementInfo rightContent, IStorageInfo projectStorageInfo, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)projectStorageInfo.getGlobalStorageSystem());
        ProjectStorageSystem projectStorageSystem = projectStorageInfo.getProjectStorageSystem();
        RepositoryLogIndex repositoryLogIndex = (RepositoryLogIndex)projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        WrappedLogEntry logEntryOfDiffCommitLeft = FindingsDetailSlideRenderer.getLogEntryAtCommit(leftUniformPath, leftCommit, userAliasLookup, repositoryLogIndex, commitDescriptorIndex, projectStorageSystem);
        WrappedLogEntry logEntryOfDiffCommitRight = FindingsDetailSlideRenderer.getLogEntryAtCommit(rightUniformPath, rightCommit, userAliasLookup, repositoryLogIndex, commitDescriptorIndex, projectStorageSystem);
        return new DiffInfo(new SelfContainedFinding.FindingContent(leftContent), new SelfContainedFinding.FindingContent(rightContent), Collections.singletonList(diffs), logEntryOfDiffCommitLeft, logEntryOfDiffCommitRight);
    }

    private static @NonNull WrappedLogEntry getLogEntryAtCommit(String uniformPath, CommitDescriptor commit, UserAliasLookup userAliasLookup, RepositoryLogIndex repositoryLogIndex, CommitDescriptorIndex commitDescriptorIndex, ProjectStorageSystem projectStorageInfo) throws StorageException {
        RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)RepositoryLastChangeUtils.findLastChangeForElementExcludingExternalUploads((String)uniformPath, (CommitDescriptor)commit, (RepositoryLogIndex)repositoryLogIndex, (ProjectStorageSystem)projectStorageInfo, (Logger)LogManager.getLogger()).get();
        ParentedCommitDescriptor parentedCommitDescriptor = commitDescriptorIndex.getCommit(logEntry.getCommit());
        UserResolvedRepositoryLogEntry entry = UserResolveUtils.resolveRepositoryLogEntry(logEntry.toAggregateLogEntryWithPrimaryRepository(), parentedCommitDescriptor, userAliasLookup);
        return new WrappedLogEntry((RepositoryLogEntry)entry, entry.getResolvedAuthor());
    }

    private static @Nullable ElementHistoryEntry getElementHistoryEntry(IStorageInfo projectStorageInfo, CommitDescriptor commit, String uniformPath) throws StorageException {
        HistoryAccessOption commitTimestampHistoryAccessOption = HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp());
        ElementHistoryIndex historyIndex = (ElementHistoryIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(ElementHistoryIndex.class, commitTimestampHistoryAccessOption);
        return historyIndex.getHistoryEntry(uniformPath);
    }

    private static FormattedTokenElementInfo loadCodeForUniformPath(String uniformPath, IStorageInfo projectStorageInfo, HistoryAccessOption historyAccessOption) throws StorageException {
        TokenElementIndex index = (TokenElementIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(TokenElementIndex.class, "content", historyAccessOption);
        TokenElementInfo content = index.getTokenElement(uniformPath);
        if (content == null) {
            return null;
        }
        ExtendedResourceTypeIndex extendedResourceTypeIndex = (ExtendedResourceTypeIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(ExtendedResourceTypeIndex.class, historyAccessOption);
        EnumSet extendedResourceTypes = extendedResourceTypeIndex.getResourceTypes(uniformPath);
        return TokenElementServiceUtils.createFormattedElementInfo(content, historyAccessOption, projectStorageInfo.getProjectStorageSystem(), extendedResourceTypes);
    }

    private UserResolvedRepositoryLogEntry loadIntroductionOrRemovalCommitLogEntry(IStorageInfo projectStorageInfo, TrackedFinding finding, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        if (finding == null) {
            return null;
        }
        RepositoryLogIndex repoLogIndex = (RepositoryLogIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(RepositoryLogIndex.class, null);
        CommitDescriptor commitToLoad = finding.getDeathCommit() != null ? finding.getDeathCommit() : finding.getBirthCommit();
        return this.userResolveEntry(Optional.ofNullable((RepositoryLogEntryAggregate)repoLogIndex.getEntry(commitToLoad)).map(RepositoryLogEntryAggregate::toAggregateLogEntryWithPrimaryRepository).orElse(null), commitDescriptorIndex);
    }

    private UserResolvedRepositoryLogEntry userResolveEntry(RepositoryLogEntry entry, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        if (entry == null) {
            return null;
        }
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.renderContext.getGlobalStorageSystem());
        return UserResolveUtils.resolveRepositoryLogEntry(entry, commitDescriptorIndex.getCommit(entry.getCommit()), userAliasLookup);
    }
}

