/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.quality_report.QualityArtifactProfile;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import jakarta.ws.rs.BadRequestException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class SlideRenderContext<T extends SlideParametersBase> {
    private final T parameters;
    private final QualityArtifactProfile qualityArtifactProfile;
    private final ITeamscaleServiceInfo serviceInfo;
    private final String reportId;

    public SlideRenderContext(ITeamscaleServiceInfo serviceInfo, T parameters, QualityArtifactProfile qualityArtifactProfile, String reportId) {
        this.serviceInfo = serviceInfo;
        this.parameters = parameters;
        this.qualityArtifactProfile = qualityArtifactProfile;
        this.reportId = reportId;
    }

    public T getParameters() {
        return this.parameters;
    }

    public QualityArtifactProfile getReportProfile() {
        return this.qualityArtifactProfile;
    }

    protected IStorageInfo resolveProjectAndReturnLocalStorageInfo(ProjectBranchPath projectBranchPath) throws StorageException {
        ProjectInfo projectInfo = this.resolveProject(projectBranchPath);
        return this.getLocalStorageInfo(projectInfo);
    }

    protected ProjectInfo resolveProject(ProjectBranchPath projectBranchPath) throws StorageException {
        PublicProjectId projectId = projectBranchPath.getProjectId();
        ProjectInfo resolvedProject = this.serviceInfo.getIndexLayer().resolveProject((IProjectId)projectId);
        if (resolvedProject == null) {
            throw new BadRequestException("Project " + String.valueOf(projectId) + " does not exist.");
        }
        this.serviceInfo.getPermissions().checkProjectPermission((IProjectId)resolvedProject.getPrimaryPublicId(), EProjectPermission.VIEW);
        return resolvedProject;
    }

    protected IStorageInfo getLocalStorageInfo(ProjectInfo projectInfo) throws StorageException {
        return IStorageInfo.create((ProjectInfo)projectInfo, (ProjectStorageSystem)this.serviceInfo.getProjectStorageSystem((IProjectId)projectInfo.getInternalId()), (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem());
    }

    public String getReportId() {
        return this.reportId;
    }

    public User getUser() {
        return this.serviceInfo.getUser();
    }

    public GlobalStorageSystem getGlobalStorageSystem() {
        return this.serviceInfo.getGlobalStorageSystem();
    }

    public ProjectStorageSystem getProjectStorageSystem(PublicProjectId projectId) throws StorageException {
        return this.serviceInfo.getProjectStorageSystem((IProjectId)projectId);
    }

    public IndexLayer getIndexLayer() {
        return this.serviceInfo.getIndexLayer();
    }

    public ServicePermissions getPermissions() {
        return this.serviceInfo.getPermissions();
    }
}

