/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.findings.calculation.FindingsServiceUtils;
import com.teamscale.index.findings.calculation.SpecItemUtils;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.service.base.TimeRangeResourceServiceBase;
import com.teamscale.service.base.TimeRangeResourceServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/delta/affected-spec-items")
public class SpecItemChurnService
extends TimeRangeResourceServiceBase {
    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_8_5_0)
    @Operation(summary="Gets the spec item churn", description="Provides a spec item churn (i.e., the list of changed spec items) for a given time range.", tags={"Delta"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Collection<TokenElementChurnWithOriginInfo> getSpecItemChurn(@BeanParam TimeRangeResourceServiceQueryOptions timeRangeParameters) throws StorageException {
        CommitDescriptor resolvedEndCommit = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)timeRangeParameters.getEnd(), () -> this.getProjectStorageSystem());
        Set possibleSpecItemBranches = SpecItemUtils.getPossibleSpecItemBranches((String)resolvedEndCommit.getBranchName(), (PublicProjectId)this.serviceInfo.getPrimaryPublicId(), (IndexLayer)this.serviceInfo.getIndexLayer());
        return FindingsServiceUtils.getSpecItemChurn((Set)possibleSpecItemBranches, (ProjectStorageSystem)this.getProjectStorageSystem((IProjectId)this.serviceInfo.getPrimaryPublicId()), (long)timeRangeParameters.getStart().getTimestamp(), (long)timeRangeParameters.getEnd().getTimestamp());
    }
}

