/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing.references;

import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.index.issue_reference.SpecItemCodeReferenceIndex;
import com.teamscale.service.requirements_tracing.references.ReferenceResolution;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class SpecItemCodeReferenceResolver {
    public static ReferenceResolution resolve(SpecItemCodeReferenceIndex referenceIndex, SpecItem item) throws StorageException {
        List references = referenceIndex.getSpecItemCodeReferences(item.getId().getInternalId());
        return SpecItemCodeReferenceResolver.resolveReferences(references);
    }

    public static List<ReferenceResolution> resolve(SpecItemCodeReferenceIndex referenceIndex, List<? extends SpecItem> items) throws StorageException {
        List references = referenceIndex.getSpecItemCodeReferences(items.stream().map(TeamscaleIssue::getId).map(TeamscaleIssueId::getInternalId).collect(Collectors.toList()));
        ArrayList<ReferenceResolution> result = new ArrayList<ReferenceResolution>(items.size());
        CollectionUtils.forEach(items, (Iterable)references, (item, reference) -> result.add(SpecItemCodeReferenceResolver.resolveReferences(reference)));
        return result;
    }

    private static ReferenceResolution resolveReferences(List<SpecItemCodeReference> references) {
        if (references == null) {
            references = List.of();
        }
        int codeReferences = 0;
        int testReferences = 0;
        for (SpecItemCodeReference specItemCodeReference : references) {
            if (specItemCodeReference.isTestReference()) {
                ++testReferences;
                continue;
            }
            ++codeReferences;
        }
        return new ReferenceResolution(codeReferences, testReferences);
    }
}

