/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testcoverage.BranchCoverageToCoverableLinesAdjuster;
import com.teamscale.index.testcoverage.CoverableBranchAnalyzer;
import com.teamscale.index.testcoverage.LineCoverageToBranchCoverageConverter;
import com.teamscale.index.testgap.query.LineCoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaCoverageSourceQueryParameters;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import com.teamscale.service.resource.CoverageServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.volume.CodeBranch;
import org.conqat.engine.sourcecode.coverage.volume.CoverableVolumeUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/branch-coverage")
public class BranchCoverageService
extends CoverageServiceBase {
    @GET
    @Path(value="{uniformPath: .*}")
    @Operation(summary="Get branch coverage", description="Returns the branch coverage data for an element.", responses={@ApiResponse(responseCode="204", description="No branch coverage is available for the given uniformPath.")}, tags={"Test Coverage", "Debugging"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public BranchCoverageInfo getBranchCoverage(@PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath, @BeanParam TgaCoverageSourceQueryParameters coverageSourceParameters, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws ConQATException, CommitResolutionException {
        if (BranchCoverageService.isPathIgnoredForCoverage(uniformPath)) {
            return new BranchCoverageInfo();
        }
        List<String> partitions = this.getRelevantCoveragePartitions(null, commit, (LineCoverageSourceQueryParameters)coverageSourceParameters);
        return this.loadCoverage(uniformPath, partitions, this.determineHistoryOption(commit));
    }

    private BranchCoverageInfo loadCoverage(UniformPath uniformPath, List<String> partitions, HistoryAccessOption historyAccessOption) throws ConQATException {
        TokenElementInfo elementInfo;
        LineCoverageInfo lineCoverageInfo = this.loadAndMergeCoverageData(uniformPath, partitions, historyAccessOption, false);
        if (lineCoverageInfo == null) {
            lineCoverageInfo = new LineCoverageInfo(-1L, -1L, false);
        }
        if ((elementInfo = TokenElementIndex.open((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption).getTokenElement(uniformPath.toString())) == null) {
            return null;
        }
        new CoverableBranchAnalyzer();
        List codeBranches = CoverableBranchAnalyzer.extractBranchInfo((TokenElementInfo)elementInfo).getCodeBranches();
        if (CoverableVolumeUtils.useCoverableVolumeFilterForCpp((String)uniformPath.toString())) {
            codeBranches = BranchCoverageToCoverableLinesAdjuster.filterCoverableBranches((List)codeBranches, (LineCoverageInfo)lineCoverageInfo);
        }
        LineCoverageToBranchCoverageConverter converter = new LineCoverageToBranchCoverageConverter(lineCoverageInfo, codeBranches);
        BranchCoverageInfo result = new BranchCoverageInfo();
        for (CodeBranch branch : codeBranches) {
            CodeBranchInfo converted = new CodeBranchInfo(branch);
            if (converter.isBranchCovered(branch)) {
                result.coveredBranches.add(converted);
                continue;
            }
            result.uncoveredBranches.add(converted);
        }
        result.coveredBranches.sort(CodeBranchInfo.STABLE_COMPARATOR);
        result.uncoveredBranches.sort(CodeBranchInfo.STABLE_COMPARATOR);
        return result;
    }

    public static class BranchCoverageInfo {
        @JsonProperty(value="coveredBranches")
        private final List<CodeBranchInfo> coveredBranches = new ArrayList<CodeBranchInfo>();
        @JsonProperty(value="uncoveredBranches")
        private final List<CodeBranchInfo> uncoveredBranches = new ArrayList<CodeBranchInfo>();
    }

    public static class CodeBranchInfo {
        private static final Comparator<CodeBranchInfo> STABLE_COMPARATOR = Comparator.comparingInt(branch -> branch.startLine).thenComparingInt(branch -> branch.endLine).thenComparing(branch -> branch.decision);
        @JsonProperty(value="startLine")
        private final int startLine;
        @JsonProperty(value="endLine")
        private final int endLine;
        @JsonProperty(value="decision")
        private final @Nullable String decision;

        private CodeBranchInfo(CodeBranch branch) {
            this.startLine = branch.getStartLine();
            this.endLine = branch.getStartLine();
            this.decision = branch.getDecision();
        }

        @JsonCreator
        private CodeBranchInfo(@JsonProperty(value="startLine") int startLine, @JsonProperty(value="endLine") int endLine, @JsonProperty(value="decision") String decision) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.decision = decision;
        }
    }
}

