/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.testcoverage.CoverageAdjuster;
import com.teamscale.index.testgap.query.LineCoverageSourceQueryParameters;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.resource.CoverageServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/test-coverage")
public class TestCoverageService
extends CoverageServiceBase {
    private static final String INCLUDE_METHOD_COVERAGE_PARAMETER_NAME = "include-method-coverage";

    @GET
    @Path(value="{uniformPath: .*}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Returns test coverage", description="Returns the line coverage data for an element.", tags={"Test Coverage"}, responses={@ApiResponse(responseCode="204", description="The uniform path is not available.")})
    public LineCoverageInfo getTestCoverage(@PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath, @BeanParam LineCoverageSourceQueryParameters coverageSourceParameters, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @QueryParam(value="include-method-coverage") @Parameter(description="If true, the coverage will include method-accurate coverage.") @DefaultValue(value="false") boolean includeMethodAccurateCoverage, @QueryParam(value="mergeRequestId") MergeRequestIdentifier mergeRequestId) throws StorageException, CommitResolutionException {
        if (TestCoverageService.isPathIgnoredForCoverage(uniformPath)) {
            return new LineCoverageInfo(false);
        }
        List<String> relevantPartitions = this.getRelevantCoveragePartitions(mergeRequestId, commit, coverageSourceParameters);
        return this.loadCoverage(uniformPath, relevantPartitions, this.determineHistoryOption(commit), includeMethodAccurateCoverage);
    }

    @GET
    @Path(value="{uniformPath: .*}")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_3_0, deprecatedSince=ETeamscaleVersion.VERSION_2024_7_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Returns test coverage", description="Returns the line coverage data for an element.", tags={"Test Coverage"}, responses={@ApiResponse(responseCode="204", description="The uniform path is not available.")})
    public LineCoverageInfo getLegacyTestCoverage(@PathParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="partitions") @Parameter(description="This parameter may be given multiple times. Specifies the test coverage partitions to consider. If this parameter is omitted every partition will be taken.") List<String> partitions, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @QueryParam(value="include-method-coverage") @Parameter(description="If true, the coverage will include method-accurate coverage.") @DefaultValue(value="false") boolean includeMethodAccurateCoverage) throws StorageException, CommitResolutionException {
        LineCoverageSourceQueryParameters coverageSourceParameters = new LineCoverageSourceQueryParameters(partitions, partitions.isEmpty());
        return this.getTestCoverage(uniformPath, coverageSourceParameters, commit, includeMethodAccurateCoverage, null);
    }

    private LineCoverageInfo loadCoverage(UniformPath uniformPath, List<String> partitions, HistoryAccessOption historyAccessOption, boolean includeMethodAccurateCoverage) throws StorageException {
        TokenElementLineInfo elementLineInfo;
        boolean lineCoverageInfoPresent;
        LineCoverageInfo result = this.loadAndMergeCoverageData(uniformPath, partitions, historyAccessOption, includeMethodAccurateCoverage);
        boolean bl = lineCoverageInfoPresent = result != null;
        if (!lineCoverageInfoPresent) {
            result = new LineCoverageInfo(-1L, -1L, false);
        }
        if ((elementLineInfo = ((TokenElementLineInfoIndex)this.getProjectStorageSystem().openProjectIndex(TokenElementLineInfoIndex.class, historyAccessOption)).getLineInfo(uniformPath.toString())) == null) {
            return null;
        }
        CoverageAdjuster.correctLineCoverage((String)uniformPath.toString(), (TokenElementLineInfo)elementLineInfo, (LineCoverageInfo)result, (boolean)lineCoverageInfoPresent);
        return result;
    }
}

