/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.EUserActivityPeriods;
import com.teamscale.index.service_log.ServiceLoadIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;

@Path(value="api/service-load")
public class ServiceLoadService
extends ApiBase {
    @GET
    @Operation(summary="Service-Load information", description="Returns information about service load.")
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    public List<LoadProfile> getServiceLoad() throws StorageException {
        ServiceLoadIndex serviceLoadIndex = this.openGlobalIndex(ServiceLoadIndex.class);
        List<EUserActivityPeriods> periods = Arrays.asList(EUserActivityPeriods.values());
        List serviceLoadData = serviceLoadIndex.getLoadEntriesSince(DateTimeUtils.zonedNow().minus(periods.getLast().getAmount()).toInstant().toEpochMilli());
        ArrayList<LoadProfile> result = new ArrayList<LoadProfile>();
        for (EUserActivityPeriods period : periods) {
            result.add(ServiceLoadService.buildLoadProfile(period, serviceLoadData));
        }
        return result;
    }

    private static LoadProfile buildLoadProfile(EUserActivityPeriods period, List<ServiceLoadIndex.ServiceLoadEntry> serviceLoadData) {
        int[] hourMaximum = new int[24];
        int[] hourSumServiceCalls = new int[24];
        int[] hourSumMinuteIntervals = new int[24];
        long threshold = DateTimeUtils.zonedNow().minus(period.getAmount()).toInstant().toEpochMilli();
        for (ServiceLoadIndex.ServiceLoadEntry entry : serviceLoadData) {
            if (entry.getTimestamp() < threshold) continue;
            int hour = ServiceLoadService.determineHour(entry.getTimestamp());
            hourMaximum[hour] = Math.max(hourMaximum[hour], entry.getMaxServiceCalls());
            int n = hour;
            hourSumServiceCalls[n] = hourSumServiceCalls[n] + entry.getSumServiceCalls();
            int n2 = hour;
            hourSumMinuteIntervals[n2] = hourSumMinuteIntervals[n2] + entry.getNumMinuteIntervals();
        }
        int[] hourAverage = new int[24];
        for (int i = 0; i < hourSumServiceCalls.length; ++i) {
            hourAverage[i] = hourSumMinuteIntervals[i] == 0 ? 0 : hourSumServiceCalls[i] / hourSumMinuteIntervals[i];
        }
        return new LoadProfile(period.getName(), hourMaximum, hourAverage);
    }

    private static int determineHour(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).getHour();
    }

    public static class LoadProfile {
        @JsonProperty(value="description")
        private final String description;
        @JsonProperty(value="hourMaximum")
        private final int[] hourMaximum;
        @JsonProperty(value="hourAverage")
        private final int[] hourAverage;

        private LoadProfile(String description, int[] hourMaximum, int[] hourAverage) {
            this.description = description;
            this.hourMaximum = hourMaximum;
            this.hourAverage = hourAverage;
        }
    }
}

