/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.debug;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.admin.ServerRenderedPageServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.UUID;
import javax.management.MBeanServer;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@Path(value="api/system/debug/heap-dump")
public class DebugHeapDumpService
extends ServerRenderedPageServiceBase {
    private static final String HOTSPOT_MXBEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean mxBeanInstance;

    @GET
    @Operation(summary="Retrieve heap dump form", description="Provides a UI to download heap dump", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/html"})
    public String getHeapDumpFormPage() {
        return this.buildHttpFormPage();
    }

    @POST
    @Operation(summary="Download heap dump", description="Downloads a heap dump in HProf format. The API requires a HotSpot-based JVM.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response downloadHeapDump(@Parameter(description="Whether dead (i.e., unreachable) objects are included in the heap dump.") @FormParam(value="include-dead-objects") boolean includeDeadObjects) throws InternalServerErrorException, IOException {
        File heapDump = new File(FileSystemUtils.getTmpDir(), String.valueOf(UUID.randomUUID()) + ".hprof");
        HotSpotDiagnosticMXBean mxBean = DebugHeapDumpService.getHotSpotDiagnosticMXBeanInstance();
        mxBean.dumpHeap(heapDump.getAbsolutePath(), !includeDeadObjects);
        StreamingOutput streamingOutput = output -> {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(heapDump));){
                FileSystemUtils.copy((InputStream)in, (OutputStream)output);
            }
            finally {
                heapDump.delete();
            }
        };
        return ResponseUtils.getFileDownloadResponse((Object)streamingOutput, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE, (String)heapDump.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HotSpotDiagnosticMXBean getHotSpotDiagnosticMXBeanInstance() throws InternalServerErrorException {
        if (mxBeanInstance != null) return mxBeanInstance;
        Class<DebugHeapDumpService> clazz = DebugHeapDumpService.class;
        synchronized (DebugHeapDumpService.class) {
            if (mxBeanInstance != null) return mxBeanInstance;
            mxBeanInstance = DebugHeapDumpService.createMXBeanInstance(HOTSPOT_MXBEAN_NAME, HotSpotDiagnosticMXBean.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mxBeanInstance;
        }
    }

    private static <T> T createMXBeanInstance(String mxBeanName, Class<T> mxBeanInterface) throws InternalServerErrorException {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(server, mxBeanName, mxBeanInterface);
        }
        catch (Exception e) {
            throw new InternalServerErrorException(String.format("Could not create %s MXBean. Does the JVM implement it?", mxBeanName), (Throwable)e);
        }
    }
}

