/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.parse_log;

import com.teamscale.core.log.parse.ParseLogIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.system.parse_log.ParseLogOverviewEntry;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/system/parse-log/overview")
public class ParseLogOverviewService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    @Operation(summary="Get parse log overview", description="Returns overview information about the parse log entries in all visible projects", tags={"Logging"})
    public List<ParseLogOverviewEntry> getAllParseLogOverviewEntries() throws StorageException {
        ArrayList<ParseLogOverviewEntry> overview = new ArrayList<ParseLogOverviewEntry>();
        for (ProjectInfo project : this.getPermissions().getVisibleProjects()) {
            try {
                ParseLogIndex parseLogIndex = (ParseLogIndex)this.getIndexLayer().openNonHistorizedProjectIndex(ParseLogIndex.class, project);
                overview.add(new ParseLogOverviewEntry(project.getName(), project.getPrimaryPublicId(), parseLogIndex.getNumberOfEntries()));
            }
            catch (StorageException e) {
                LOGGER.error("Error obtaining information for project " + String.valueOf(project) + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return overview;
    }
}

