/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.scheduler;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@Path(value="api/scheduler")
public class SchedulerPauseService
extends ApiBase {
    @GET
    @Path(value="mode")
    @Operation(summary="Get scheduler filtering status", description="Returns the current filtering status of the scheduler.", tags={"System"})
    @RequiresNoPermission
    public ProjectSchedulingFilter getCurrentSchedulingFilter() throws StorageException {
        WorkerIndex workerIndex = this.openGlobalIndex(WorkerIndex.class);
        ProjectSchedulingFilter projectSchedulingFilter = workerIndex.getSchedulingFilterAccess().get();
        List visibleProjects = this.getPermissions().getVisibleProjects(true, true);
        projectSchedulingFilter.retainOnlyVisibleProjects((Collection)CollectionUtils.map((Collection)visibleProjects, ProjectInfo::getInternalId));
        return projectSchedulingFilter.replaceInternalIdsByPublicIds(visibleProjects);
    }

    @PUT
    @Path(value="projects/{project}")
    @Operation(summary="Set project scheduling", description="Pauses or resumes the scheduling for a specific project.", tags={"Project", "System"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    public void setProjectSchedulePausing(@PathParam(value="project") PublicProjectId projectId, @RequestBody EProjectScheduleCommand projectScheduleRequest) throws StorageException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        InternalProjectId internalProjectId = projectIndex.resolveToInternalId((IProjectId)projectId);
        switch (projectScheduleRequest.ordinal()) {
            case 0: {
                ProjectSchedulingFilter.pauseProject((InternalProjectId)internalProjectId, (GlobalStorageSystem)this.getGlobalStorageSystem());
                break;
            }
            case 1: {
                ProjectSchedulingFilter.resumeProjectIfPaused((InternalProjectId)internalProjectId, (GlobalStorageSystem)this.getGlobalStorageSystem());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized project schedule command: " + String.valueOf((Object)projectScheduleRequest));
            }
        }
    }

    @PUT
    @Path(value="mode")
    @Operation(summary="Set scheduler filtering status", description="Sets the filtering status of the scheduler", tags={"System"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void setSchedulingMode(@RequestBody ProjectSchedulingFilter.ESchedulingMode schedulingMode) throws StorageException {
        ProjectSchedulingFilter.setSchedulerMode((ProjectSchedulingFilter.ESchedulingMode)schedulingMode, (GlobalStorageSystem)this.getGlobalStorageSystem(), (String)"Requested by API");
    }

    @ExportToTypeScript
    public static enum EProjectScheduleCommand {
        PAUSE,
        UNPAUSE;

    }
}

