/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.upload;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.dotnet.DotNetMethodMappingIndex;
import com.teamscale.index.testgap.dotnet.DotNetVersionIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.upload.base.ExternalUploadServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

@Path(value="api/projects/{project}/mappings/dot-net-stored-mappings")
public class DotNetStoredMappingsService
extends ApiBase {
    @GET
    @Operation(summary="Get stored mappings", description="Returns stored dot net method mappings (assembly method id to path and method region) as a CSV file.", tags={"External Analysis", "Debugging"}, responses={@ApiResponse(responseCode="400", description="Missing value for parameter version."), @ApiResponse(responseCode="400", description="The provided program version is not known to Teamscale.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Produces(value={"text/csv"})
    public Response getStoredMappings(@Parameter(description="The parameter that contains the program version to which the uploaded coverage belongs.", required=true) @QueryParam(value="version") String version) throws StorageException, BadRequestException {
        DotNetVersionIndex versionIndex = this.openProjectIndex(DotNetVersionIndex.class, null);
        CommitDescriptor commitForVersion = ExternalUploadServiceUtils.getCommitDescriptorFromVersionIndex(versionIndex, version);
        DotNetMethodMappingIndex mappingIndex = this.openProjectIndex(DotNetMethodMappingIndex.class, ExternalUploadServiceUtils.getAccessOptionForDefaultBranch(commitForVersion));
        String entity = DotNetStoredMappingsService.createCsv(mappingIndex);
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)"dotnet-debug-info-mappings.csv");
    }

    private static String createCsv(DotNetMethodMappingIndex mappingIndex) throws StorageException {
        String string;
        PairList mappings = mappingIndex.getAllMappings();
        StringWriter stringWriter = new StringWriter();
        try {
            try (CsvListWriter csvListWriter = new CsvListWriter((Writer)stringWriter, CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE);){
                csvListWriter.writeHeader(new String[]{"Assembly", "AssemblyMethodId", "TeamscaleUniformPath", "MethodRegionStartInFile", "MethodRegionEndInFile"});
                for (Pair currentMapping : mappings) {
                    String[] assemblyAndMethodToken = ((String)currentMapping.getFirst()).split("#!#");
                    SourceLocation methodSourceLocation = (SourceLocation)currentMapping.getSecond();
                    csvListWriter.write(new Object[]{assemblyAndMethodToken[0], assemblyAndMethodToken[1], methodSourceLocation.getUniformPath(), methodSourceLocation.getRegion().getStart(), methodSourceLocation.getRegion().getEnd()});
                }
            }
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stringWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InternalServerErrorException("Unable to create CSV", (Throwable)e);
            }
        }
        stringWriter.close();
        return string;
    }
}

