/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.upload;

import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.index.testgap.dotnet.DotNetVersionIndex;
import com.teamscale.index.testgap.dotnet.DotNetVersionInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/dot-net-versions")
public class GlobalDotNetVersionService
extends ApiBase {
    @GET
    @Operation(summary="Get .NET versions", description="Returns a list of all versions known by uploaded PDBs for the given projects or for all visible projects if no project ID is given.", tags={"Project"})
    @RequiresNoPermission(description="No permissions needed, as the service checks if all listed projects are visible to the user.")
    public Map<String, List<DotNetVersionInfo>> getDotNetVersions(@QueryParam(value="project") List<String> projectIds) throws StorageException {
        return this.getAllDotNetVersionsByProjects(projectIds);
    }

    private Map<String, List<DotNetVersionInfo>> getAllDotNetVersionsByProjects(List<String> projectIds) throws StorageException {
        List projects = PermissionUtils.getVisibleProjectIds((GlobalStorageSystem)this.getGlobalStorageSystem(), (ServicePermissions)this.getPermissions(), (List)PublicProjectId.of(projectIds));
        if (projects.isEmpty()) {
            return new HashMap<String, List<DotNetVersionInfo>>();
        }
        HashMap<String, List<DotNetVersionInfo>> dotNetVersionsByProject = new HashMap<String, List<DotNetVersionInfo>>();
        for (IProjectId project : projects) {
            if (!this.serviceInfo.getProjectStorageSystem(project).hasIndex("dot-net-program-versions")) continue;
            DotNetVersionIndex dotNetVersionIndex = (DotNetVersionIndex)this.serviceInfo.getProjectStorageSystem(project).openProjectIndex(DotNetVersionIndex.class, null);
            dotNetVersionsByProject.put(project.toString(), dotNetVersionIndex.getAllVersions().toList(DotNetVersionInfo::new));
        }
        return dotNetVersionsByProject;
    }
}

