/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.information_retrieval;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.testimpact.information_retrieval.RelatedTestsRequestOptions;
import com.teamscale.service.testimpact.information_retrieval.RelatedTestsResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

public interface IRelatedTestSearchService {
    public static final String TEST_SELECTION_IR_SUMMARY = "Get the set of tests that are related to the given code delta. The code delta is defined by a baseline and an issue id.";
    public static final String TEST_SELECTION_IR_DESCRIPTION = "Tests are selected based on information retrieval techniques. The scoring operator to use can be configured by a corresponding parameter. If an issue id is provided, all code modified or added in context of the issue is considered. If both a baseline and an issue id are provided, the union of the deltas is considered.";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get the set of tests that are related to the given code delta. The code delta is defined by a baseline and an issue id.", description="Tests are selected based on information retrieval techniques. The scoring operator to use can be configured by a corresponding parameter. If an issue id is provided, all code modified or added in context of the issue is considered. If both a baseline and an issue id are provided, the union of the deltas is considered.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="412", description="The given commit has not been processed yet."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    public RelatedTestsResult getRelatedTests(@BeanParam RelatedTestsRequestOptions var1) throws StorageException;

    @GET
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="As CSV: Get the set of tests that are related to the given code delta. The code delta is defined by a baseline and an issue id.", description="Tests are selected based on information retrieval techniques. The scoring operator to use can be configured by a corresponding parameter. If an issue id is provided, all code modified or added in context of the issue is considered. If both a baseline and an issue id are provided, the union of the deltas is considered.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="412", description="The given commit has not been processed yet."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    @Path(value="csv")
    @Produces(value={"text/csv"})
    public Response getRelatedTestsCsv(@BeanParam RelatedTestsRequestOptions var1) throws StorageException;

    public record TestMatchingScore(UniformPath uniformPath, double score, @Nullable String matchExplanation) {
    }
}

