/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization.strategies;

import com.teamscale.service.testimpact.prioritization.ETestSelectionReason;

public enum ERoundState {
    ROUND_FAILED_TESTS(ETestSelectionReason.PREVIOUSLY_FAILED),
    ROUND_SKIPPED_TESTS(ETestSelectionReason.PREVIOUSLY_SKIPPED),
    ROUND_COVER_CHANGES_ONCE(ETestSelectionReason.COVERS_CHANGES),
    ROUND_CHANGED_TESTS(ETestSelectionReason.ADDED_OR_MODIFIED_TEST),
    ROUND_DELETED_FUNCTIONALITY_TESTS(ETestSelectionReason.COVERS_DELETED),
    ROUND_COVER_CHANGES_TO_EXHAUSTION(ETestSelectionReason.COVERS_CHANGES),
    ROUND_APPEND_REST(ETestSelectionReason.COVERS_OTHER);

    private final ETestSelectionReason testSelectionReason;

    private ERoundState(ETestSelectionReason testSelectionReason) {
        this.testSelectionReason = testSelectionReason;
    }

    public ERoundState nextState() {
        ERoundState[] values = ERoundState.values();
        return values[Math.min(this.ordinal() + 1, values.length - 1)];
    }

    public static ERoundState startState() {
        return ROUND_FAILED_TESTS;
    }

    public boolean isEndState() {
        return this == ROUND_APPEND_REST;
    }

    public boolean isCoverageBasedPrioritizationRound() {
        return this == ROUND_COVER_CHANGES_ONCE || this == ROUND_COVER_CHANGES_TO_EXHAUSTION;
    }

    public ETestSelectionReason getRelevantTestSelectionReason() {
        return this.testSelectionReason;
    }
}

