/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.stacktrace.StacktraceParserFacade;
import com.teamscale.index.stacktrace.component.Stacktrace;
import com.teamscale.index.stacktrace.parser.StacktraceParser;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/tests/{test}/stacktrace")
public class StacktraceService
extends ApiBase {
    private static final String PARTITION_PARAMETER_DESCRIPTION = "This parameter must be set to the partition in which the test was uploaded.";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get stacktrace of failed test execution", description="Retrieves the stacktrace of the failed test execution at a given uniform path.", tags={"Tests"}, responses={@ApiResponse(responseCode="404", description="Test execution could not be found."), @ApiResponse(responseCode="204", description="Test execution did not contain a stacktrace.")})
    public Stacktrace getStacktrace(@Parameter(description="Uniform path to retrieve the stacktrace for") @PathParam(value="test") UniformPath uniformPath, @Parameter(description="This parameter must be set to the partition in which the test was uploaded.", required=true) @QueryParam(value="partition") String partition, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, historyAccessOption);
        TestExecutionWithPartition testExecutionWithPartition = testExecutionIndex.getTestExecution(partition, uniformPath);
        if (testExecutionWithPartition == null) {
            throw new NotFoundException("Test execution for partition " + partition + " at " + String.valueOf(uniformPath) + " could not be found.");
        }
        Optional failureMessage = testExecutionWithPartition.getTestExecution().getMessage();
        if (failureMessage.isEmpty()) {
            return null;
        }
        PathLookupIndex pathLookupIndex = this.openProjectIndex(PathLookupIndex.class, historyAccessOption);
        try {
            return StacktraceParserFacade.parseStacktraceWithUniformPath((String)((String)failureMessage.get()), (PathLookupIndex)pathLookupIndex);
        }
        catch (StacktraceParser.StacktraceParserException e) {
            return null;
        }
    }
}

