/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.treemap;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.service.treemap.MethodBasedTreeMapNodeBase;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;

@NoIndexValueClass(rationale="Only used as DTO")
@Schema(allOf={MethodBasedTreeMapNodeBase.class})
public final class FindingsResolvedMethodTreeMapNode
extends MethodBasedTreeMapNodeBase {
    @JsonIgnore
    private final List<? extends DetachedFinding> findings;
    @JsonProperty(value="numberOfFindings")
    private int aggregatedNumberOfFindings;

    public FindingsResolvedMethodTreeMapNode(String uniformPath) {
        super(uniformPath);
        this.findings = Collections.emptyList();
    }

    public FindingsResolvedMethodTreeMapNode(UniformPath uniformPath, AssociatedMethodInfo methodInfo, List<? extends DetachedFinding> findings, Collection<TeamscaleIssueId> matchingIssues) {
        super(uniformPath.toString(), methodInfo.getLocation().getRegion(), methodInfo.getMethodName(), matchingIssues);
        this.findings = findings;
        this.aggregatedNumberOfFindings = findings.size();
    }

    public int getNumberOfFindings() {
        return this.aggregatedNumberOfFindings;
    }

    public UnmodifiableList<? extends DetachedFinding> getFindings() {
        return CollectionUtils.asUnmodifiable(this.findings);
    }

    @Override
    public void aggregateValues() {
        super.aggregateValues();
        if (this.getChildren().isEmpty()) {
            return;
        }
        this.aggregatedNumberOfFindings = this.getChildren().stream().map(FindingsResolvedMethodTreeMapNode.class::cast).mapToInt(FindingsResolvedMethodTreeMapNode::getNumberOfFindings).sum();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtils.unsupportedWriteObject((ObjectOutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SerializationUtils.unsupportedReadObject((ObjectInputStream)in);
    }
}

