/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.upload;

import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageLookup;
import com.teamscale.index.external.input.external_storage.migration.StorageBackendMigrationTrigger;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/external-storage/migrate-uploads/{target}")
public class StorageBackendMigrationService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @POST
    @RequiresNoPermission(description="The user needs to have \"Edit Project\" and \"Perform External Uploads\" permissions on the given project IDs.")
    @Operation(summary="Migrate internally stored uploads to the external storage backend", description="Triggers a migration of all uploads in the given projects that were stored internally in Teamscale to the respective external storage backend for the project.", tags={"External Storage Backends"})
    public void triggerMigrations(@PathParam(value="target") String targetStorageName, @RequestBody List<PublicProjectId> projectIds) throws StorageException {
        if (CollectionUtils.isNullOrEmpty(projectIds)) {
            LOGGER.error("No project IDs were provided.");
            return;
        }
        this.checkPermissions(projectIds);
        for (PublicProjectId projectId : projectIds) {
            this.migrateProject(projectId, targetStorageName);
        }
    }

    @POST
    @Path(value="{projectId}")
    @RequiresNoPermission(description="The user needs to have \"Edit Project\" and \"Perform External Uploads\" permissions on the given project ID.")
    @Operation(summary="Migrate internally stored uploads to the external storage backend", description="Triggers a migration of all uploads in the given project that were stored internally in Teamscale to the respective external storage backend for the project.", responses={@ApiResponse(responseCode="404", description="If no external storage is found for the given name.")}, tags={"External Storage Backends"})
    public void triggerMigration(@PathParam(value="projectId") PublicProjectId projectId, @PathParam(value="target") String targetStorageName) throws StorageException {
        this.checkPermissions(List.of(projectId));
        this.migrateProject(projectId, targetStorageName);
    }

    private void migrateProject(PublicProjectId projectId, String targetStorageName) throws StorageException, NotFoundException {
        Optional externalStorageBackend = ExternalStorageLookup.getStorageBackend((InternalProjectId)this.getIndexLayer().resolveToInternalProjectId((IProjectId)projectId), (String)targetStorageName, (ExternalStorageBackendIndex)this.openGlobalIndex(ExternalStorageBackendIndex.class));
        if (externalStorageBackend.isEmpty()) {
            throw new NotFoundException("No external storage backend was found for " + targetStorageName);
        }
        InternalProjectId internalProjectId = this.getIndexLayer().resolveToInternalProjectId((IProjectId)projectId);
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), JobDescriptor.createMaintenanceTriggerWithParameter(StorageBackendMigrationTrigger.class, (Object)new StorageBackendMigrationTrigger.JobParameter(internalProjectId, (ExternalStorageBackend)externalStorageBackend.get()), (String)"Upload migration scheduled by user service call."));
    }

    private void checkPermissions(Collection<PublicProjectId> projectIds) throws StorageException {
        ServicePermissions permissions = this.getPermissions();
        for (PublicProjectId projectId : projectIds) {
            permissions.checkProjectPermission((IProjectId)projectId, EProjectPermission.EDIT);
            permissions.checkProjectPermission((IProjectId)projectId, EProjectPermission.EXTERNAL_UPLOADS);
        }
    }
}

