/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.EUserActivityPeriods;
import com.teamscale.core.user.ProjectUserActivityIndex;
import com.teamscale.core.user.UserLastActivityIndex;
import com.teamscale.index.usage_data.UsageDataCollector;
import com.teamscale.index.usage_data.UserActivity;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;

@Path(value="api/user-activity-history")
public class UserLastActivityService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_USER_STATISTICS})
    @Operation(summary="Returns user activity statistics.", tags={"Users", "License"}, description="Returns the number of users who have been active during different time durations.")
    public List<UserActivity> calculateActiveUsersStatistics() throws StorageException {
        UserLastActivityIndex lastActivityIndex = this.openGlobalIndex(UserLastActivityIndex.class);
        List lastActivityTimestamps = lastActivityIndex.getLastActivityTimestamps();
        return Stream.of(EUserActivityPeriods.values()).map(period -> new UserActivity(period.getName(), UsageDataCollector.calculateActiveUsers((TemporalAmount)period.getAmount(), (List)lastActivityTimestamps))).toList();
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_USER_STATISTICS})
    @Operation(summary="Returns active users (anonymized) for the given primary project IDs", tags={"License"}, description="For the given primary project IDs, returns all users (anonymized) of the given last number of days that contribute to the license volume. If an empty list is provided, all current projects will be included. The results might differ from the GET query in case the primary project id of a project changed in the last three months or if a user has logged into Teamscale but has not interacted with any project.")
    public List<String> getActiveUsersForProjects(@RequestBody(required=true) Set<String> projectIds, @Parameter(description="Number of days") @QueryParam(value="number-of-days") @DefaultValue(value="90") int numberOfDays) throws StorageException {
        Collection publicProjectIds;
        ProjectUserActivityIndex projectUsersIndex = this.openGlobalIndex(ProjectUserActivityIndex.class);
        if (projectIds.isEmpty()) {
            ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
            publicProjectIds = projectIndex.getAllPrimaryPublicProjectIds();
        } else {
            publicProjectIds = PublicProjectId.of(projectIds);
        }
        Instant startTimestamp = DateTimeUtils.zonedNow().minus(Period.ofDays(numberOfDays)).toInstant();
        Instant endTimestamp = DateTimeUtils.zonedNow().plusDays(1L).toInstant();
        HashSet activeUsers = new HashSet();
        for (PublicProjectId projectID : publicProjectIds) {
            activeUsers.addAll(projectUsersIndex.getUniqueUsers(projectID, startTimestamp, endTimestamp));
        }
        return activeUsers.stream().sorted().toList();
    }
}

