/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook;

import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.index.repository.artifact_store.s3.S3ArchiveIndex;
import com.teamscale.index.repository.artifact_store.s3.S3ChangeRetriever;
import com.teamscale.index.repository.artifact_store.s3.S3RepositoryInfo;
import com.teamscale.index.s3.S3UriParser;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionMap;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.SetMapCollector;

@Path(value="api/s3/web-hook")
public class S3WebhookService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @POST
    @Operation(summary="Trigger S3 commit hook", description="Allows to trigger updates of S3 repos via a commit hook. Returns a map from (potentially) affected project connectors to their associated keys.")
    @RequiresNoPermission(description="Only projects that are visible to the user and for which the user has the \"Trigger Commit Hook\" permission will be affected by the commit hook")
    @Consumes(value={"application/json"})
    public SetMap<String, String> triggerS3CommitHook(@Parameter(description="The complete list of S3 URIs that were changed in the commit and should now be fetched incrementally") @RequestBody(required=true) List<String> affectedUris) throws StorageException {
        SetMap affectedProjectConnectorIds = new SetMap();
        ProjectIndex projectIndex = this.getIndexLayer().openProjectIndex();
        SetMap<String, String> changedS3KeysByRepository = S3WebhookService.convertToS3KeysAndGroupByRepository(affectedUris);
        for (ProjectInfo projectInfo : CollectionUtils.filterWithException((Collection)projectIndex.getAllProjectInfos(), this::shouldIncludeProject)) {
            SetMap<String, String> connectorIdentifierToS3Keys = this.computeAffectedConnectorIdentifiers(projectInfo, changedS3KeysByRepository);
            for (Map.Entry connectorIdentifierToS3Key : connectorIdentifierToS3Keys) {
                String connectorIdentifier = (String)connectorIdentifierToS3Key.getKey();
                Set s3KeysForConnector = (Set)connectorIdentifierToS3Key.getValue();
                this.setKeysToScanIncrementally(projectInfo, connectorIdentifier, s3KeysForConnector);
                this.scheduleChangeRetriever(projectInfo.getInternalId(), connectorIdentifier);
            }
            affectedProjectConnectorIds.addAll((CollectionMap)connectorIdentifierToS3Keys.mapKeys(key -> String.valueOf(projectInfo.getPrimaryPublicId()) + "-" + key));
        }
        return affectedProjectConnectorIds;
    }

    private boolean shouldIncludeProject(ProjectInfo projectInfo) throws StorageException {
        if (projectInfo.isDeletingOrReanalyzing()) {
            return false;
        }
        return this.getPermissions().userHasProjectPermission((IProjectId)projectInfo.getInternalId(), EProjectPermission.TRIGGER_COMMIT_HOOK);
    }

    private static SetMap<String, String> convertToS3KeysAndGroupByRepository(List<String> affectedUris) {
        return (SetMap)affectedUris.stream().map(URI::create).map(S3UriParser::parseUri).collect(SetMapCollector.collect(S3UriParser.ParsedUri::toLookupKey, S3UriParser.ParsedUri::getKey));
    }

    private void scheduleChangeRetriever(InternalProjectId projectId, String connectorIdentifier) throws StorageException {
        String changeRetriever = TriggerBuilder.buildTriggerName((String)connectorIdentifier, (String)S3ChangeRetriever.class.getSimpleName());
        LOGGER.debug("Scheduling change retriever {}", (Object)changeRetriever);
        ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(this.getIndexLayer(), projectId, changeRetriever);
    }

    private void setKeysToScanIncrementally(ProjectInfo projectInfo, String connectorIdentifier, Set<String> s3KeysForConnector) throws StorageException {
        LOGGER.debug("Setting keys to scan incrementally for {}: {}", (Object)connectorIdentifier, s3KeysForConnector);
        this.openArchiveIndex(projectInfo, connectorIdentifier).runWithIncrementalScanLock(lockedIndex -> lockedIndex.addKeysForIncrementalScan(s3KeysForConnector));
    }

    private S3ArchiveIndex openArchiveIndex(ProjectInfo projectInfo, String connectorIdentifier) throws StorageException {
        return S3ArchiveIndex.open((ProjectStorageSystem)this.getIndexLayer().openProjectStorageSystem(projectInfo), (String)connectorIdentifier);
    }

    private SetMap<String, String> computeAffectedConnectorIdentifiers(ProjectInfo projectInfo, SetMap<String, String> affectedS3KeysByRepository) throws StorageException {
        SetMap affectedConnectorIdentifiers = new SetMap();
        for (Map.Entry repositoryAndAffectedS3Keys : affectedS3KeysByRepository) {
            String repository = (String)repositoryAndAffectedS3Keys.getKey();
            Set affectedS3Keys = (Set)repositoryAndAffectedS3Keys.getValue();
            List potentiallyAffectedTriggers = RepositoryUpdateUtils.getTriggerNamesForProject((ProjectInfo)projectInfo, (String)repository, (IndexLayer)this.getIndexLayer());
            if (potentiallyAffectedTriggers.isEmpty()) continue;
            SetMap<String, String> s3KeysByConnectorIdentifier = this.groupS3KeysByAffectedConnectorIdentifier(projectInfo, affectedS3Keys);
            affectedConnectorIdentifiers.addAll(s3KeysByConnectorIdentifier);
        }
        return affectedConnectorIdentifiers;
    }

    private SetMap<String, String> groupS3KeysByAffectedConnectorIdentifier(ProjectInfo projectInfo, Set<String> s3Keys) throws StorageException {
        SetMap connectionIdentifiersToAffectedKeys = new SetMap();
        for (ConnectorConfiguration s3Connector : this.getS3Connectors(projectInfo)) {
            List<String> keyPrefixes = S3WebhookService.computeKeyPrefixes(s3Connector);
            for (String s3Key : s3Keys) {
                if (!keyPrefixes.stream().anyMatch(s3Key::startsWith)) continue;
                connectionIdentifiersToAffectedKeys.add((Object)s3Connector.getIdentifier(), (Object)s3Key);
            }
        }
        return connectionIdentifiersToAffectedKeys;
    }

    private static List<String> computeKeyPrefixes(ConnectorConfiguration s3Connector) {
        S3RepositoryInfo s3RepositoryInfo = new S3RepositoryInfo();
        s3RepositoryInfo.setIncludeAndExcludePatterns(s3Connector);
        return s3RepositoryInfo.getKeyPrefixes();
    }

    private List<ConnectorConfiguration> getS3Connectors(ProjectInfo projectInfo) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((ProjectInfo)projectInfo, (IndexLayer)this.getIndexLayer());
        return projectConfiguration.getConnectorsByName(ERepositoryConnector.S3.getReadableName());
    }
}

