/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.analysis.cs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.LineSplitter;

public class XrBaboonReportHandler {
    private final CoverageInfoRetriever lineCoverageInfoRetriever;
    private static final Pattern lineCoverageInfoPattern = Pattern.compile("^(.*):(\\d+) (\\d+)$");

    public XrBaboonReportHandler(CoverageInfoRetriever lineCoverageInfoRetriever) {
        CCSMAssert.isNotNull((Object)lineCoverageInfoRetriever);
        this.lineCoverageInfoRetriever = lineCoverageInfoRetriever;
    }

    public void handleReport(String report) {
        for (String line : new LineSplitter(report)) {
            Matcher matcher = lineCoverageInfoPattern.matcher(line);
            if (!matcher.matches()) continue;
            this.processCoverageInfoLine(matcher);
        }
    }

    private void processCoverageInfoLine(Matcher matcher) {
        String file = matcher.group(1);
        int line = Integer.parseInt(matcher.group(2));
        int passes = Integer.parseInt(matcher.group(3));
        this.lineCoverageInfoRetriever.getOrCreateLineCoverageInfo(file).addLineCoverage(line, XrBaboonReportHandler.getLineCoverage(passes));
    }

    private static ELineCoverage getLineCoverage(int executionCount) {
        if (executionCount > 0) {
            return ELineCoverage.FULLY_COVERED;
        }
        return ELineCoverage.NOT_COVERED;
    }
}

