/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import eu.cqse.check.framework.typetracker.abap.AbapTypeInfoExtractor;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class CoverableStatementUtils {
    private static final EnumSet<ETokenType> COVERAGE_REQUIRED_TOKEN_TYPES = EnumSet.of(ETokenType.EQ, new ETokenType[]{ETokenType.LPAREN, ETokenType.LSHIFT, ETokenType.PLUSPLUS, ETokenType.MINUSMINUS, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.POWEREQ, ETokenType.XOREQ, ETokenType.ANDEQ, ETokenType.OREQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.RSHIFT});
    private static final EnumSet<ETokenType> JUMP_KEYWORDS = EnumSet.of(ETokenType.BREAK, new ETokenType[]{ETokenType.CONTINUE, ETokenType.RETURN, ETokenType.YIELD, ETokenType.THROW, ETokenType.GOTO});
    private static final EnumSet<EShallowEntityType> DEFAULT_COVERABLE_ENTITY_TYPES = EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE, EShallowEntityType.METHOD);
    private static final Set<String> FILTERED_SUBTYPES = new CaseInsensitiveStringSet(Set.of("else", "try", "finally", "ranges", "field-groups", "types", "except", "property", "empty statement"));
    public static final TokenPattern OBJECTIVE_C_MESSAGE_STATEMENT_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.LBRACK, EnumSet.of(ETokenType.IDENTIFIER, ETokenType.SELF, ETokenType.SUPER), ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LBRACK, (Object)ETokenType.RBRACK, true).skipTo(new Object[]{ETokenType.RBRACK, ETokenType.SEMICOLON});

    public static boolean containsCoverableStatements(ShallowEntity entity) {
        List entities = ShallowEntityTraversalUtils.listAllEntities((Collection)entity.getChildren());
        return !CollectionUtils.allMatch((Collection)entities, CoverableStatementUtils::isNonCoverableEntity) || !CoverableStatementUtils.isNonCoverableEntity(entity) && entity.hasChildren();
    }

    public static Collection<ShallowEntity> filterNonCoverableStatements(List<ShallowEntity> entities) {
        return CollectionUtils.filter(entities, entity -> !CoverableStatementUtils.isNonCoverableEntity(entity));
    }

    private static boolean isNonCoverableEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        if (tokens.isEmpty() || FILTERED_SUBTYPES.contains(entity.getSubtype())) {
            return true;
        }
        if (entity.getType() == EShallowEntityType.ATTRIBUTE && EFeatureToggle.SKIP_CLASS_ATTRIBUTES_FOR_COVERAGE.isEnabled()) {
            return true;
        }
        ELanguage language = ((IToken)tokens.getFirst()).getLanguage();
        if (CoverableStatementUtils.isDartGetter(entity, language)) {
            return false;
        }
        if (CoverableStatementUtils.isDefinitelyNonCoverableMethodEntity(entity, language)) {
            return true;
        }
        if (language == ELanguage.OBJECTIVE_C && CoverableStatementUtils.isObjectMessagingStatement(entity)) {
            return false;
        }
        return switch (language) {
            case ELanguage.ABAP -> {
                if (CoverableStatementUtils.isNonCoverableType(entity, language) || CoverableStatementUtils.isNonCoverableAbapStatement(entity)) {
                    yield true;
                }
                yield false;
            }
            case ELanguage.ADA -> {
                if (CoverableStatementUtils.isNonCoverableType(entity, language) || CoverableStatementUtils.isWhenWithinCase(entity)) {
                    yield true;
                }
                yield false;
            }
            case ELanguage.C, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP -> {
                if (CoverableStatementUtils.isNonCoverableDeclaration(entity, language) || CoverableStatementUtils.isNonCoverableCStatement(entity, (List<IToken>)tokens)) {
                    yield true;
                }
                yield false;
            }
            case ELanguage.GROOVY, ELanguage.PYTHON -> CoverableStatementUtils.isNonCoverableType(entity, language);
            case ELanguage.IEC61131 -> {
                if (entity.getType() != EShallowEntityType.STATEMENT) {
                    yield true;
                }
                yield false;
            }
            case ELanguage.SWIFT -> {
                if (!CoverableStatementUtils.isCoverableInSwift(entity)) {
                    yield true;
                }
                yield false;
            }
            default -> CoverableStatementUtils.isNonCoverableDeclaration(entity, language);
        };
    }

    private static boolean isDartGetter(ShallowEntity entity, ELanguage language) {
        return language == ELanguage.DART && entity.getType() == EShallowEntityType.METHOD && entity.includedTokens().stream().anyMatch(token -> token.getType() == ETokenType.GET);
    }

    private static boolean isCoverableInSwift(ShallowEntity entity) {
        if (entity.getType() == EShallowEntityType.ATTRIBUTE && entity.getSubtype().equals("attribute")) {
            if (entity.hasChildren()) {
                return true;
            }
            if (TokenStreamUtils.containsAny((List)entity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.STATIC})) {
                return false;
            }
            return TokenStreamUtils.containsSequence((List)entity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.EQ});
        }
        if (entity.getType() == EShallowEntityType.META && "annotation".equals(entity.getSubtype()) && CoverableStatementUtils.hasParentOfSubtype(entity, "struct")) {
            return true;
        }
        return entity.getType() == EShallowEntityType.METHOD && !CoverableStatementUtils.hasParentOfSubtype(entity, "protocol");
    }

    private static boolean isDefinitelyNonCoverableMethodEntity(ShallowEntity entity, ELanguage language) {
        if (entity.getType() != EShallowEntityType.METHOD) {
            return false;
        }
        if (language == ELanguage.CS) {
            return false;
        }
        if (language == ELanguage.SWIFT) {
            return CoverableStatementUtils.hasParentOfSubtype(entity, "protocol");
        }
        if (language == ELanguage.JAVASCRIPT) {
            return entity.getParent() != null && !Arrays.asList("assigned function", "assigned lambda").contains(entity.getSubtype()) && !"exports".equals(entity.getName());
        }
        return true;
    }

    private static boolean isNonCoverableCStatement(ShallowEntity entity, List<IToken> tokens) {
        if (entity.getType() == EShallowEntityType.ATTRIBUTE) {
            if ("global variable".equals(entity.getSubtype())) {
                return true;
            }
            if (CoverableStatementUtils.hasParentOfSubtype(entity, "struct")) {
                return true;
            }
            if ("enum literal".equals(entity.getSubtype())) {
                return true;
            }
        }
        return CoverableStatementUtils.isCompileTimeEvaluatedCStatement(entity, tokens);
    }

    private static boolean isCompileTimeEvaluatedCStatement(ShallowEntity entity, List<IToken> tokens) {
        if (!tokens.isEmpty() && tokens.get(0).getType() == ETokenType.STATIC_ASSERT) {
            return true;
        }
        return "if".equals(entity.getSubtype()) && tokens.size() > 2 && tokens.get(1).getType() == ETokenType.CONSTEXPR;
    }

    private static boolean isNonCoverableDeclaration(ShallowEntity entity, ELanguage language) {
        Boolean result;
        if (ShallowParsingUtils.isConstructorWithInitializerList((ELanguage)language, (ShallowEntity)entity)) {
            return false;
        }
        if (CoverableStatementUtils.isNonCoverableType(entity, language)) {
            return true;
        }
        UnmodifiableList tokens = entity.includedTokens();
        if (JUMP_KEYWORDS.contains(((IToken)tokens.getFirst()).getType())) {
            return false;
        }
        if ((language == ELanguage.CPP || language == ELanguage.CPP_MS_CLI) && (result = CoverableStatementUtils.isCppNonCoverableConstantOrInitialization(entity, (List<IToken>)tokens)) != null) {
            return result;
        }
        if (language == ELanguage.CS) {
            if (CoverableStatementUtils.isCsExpressionBodiedMethodContent(entity)) {
                return false;
            }
            if (CoverableStatementUtils.isCsAutoProperty(entity)) {
                return false;
            }
            if (entity.getType() == EShallowEntityType.METHOD) {
                return true;
            }
        }
        if (language == ELanguage.GO && CoverableStatementUtils.isNonTopLevelGoVariable(entity)) {
            return false;
        }
        if (language != ELanguage.KOTLIN && !CoverableStatementUtils.isJavaScriptEnum(language, entity) && !CoverableStatementUtils.containsCoverageRequiringTokenTypes(language, (List<IToken>)tokens)) {
            return true;
        }
        return switch (language) {
            case ELanguage.CS -> TokenStreamUtils.contains((List)tokens, (ETokenType)ETokenType.CONST);
            case ELanguage.JAVA -> CoverableStatementUtils.isPrimitiveJavaConstant((List<IToken>)tokens);
            case ELanguage.KOTLIN -> CoverableStatementUtils.isTopLevelKotlinConstant(entity, (List<IToken>)tokens);
            case ELanguage.JAVASCRIPT -> CoverableStatementUtils.isJavaScriptNonCoverableDeclaration(entity);
            case ELanguage.GO -> CoverableStatementUtils.isTopLevelGoVariable(entity);
            default -> false;
        };
    }

    private static boolean containsCoverageRequiringTokenTypes(ELanguage language, List<IToken> tokens) {
        return TokenStreamUtils.containsAny(tokens, COVERAGE_REQUIRED_TOKEN_TYPES) || CoverableStatementUtils.containsCppRShift(language, tokens);
    }

    private static boolean containsCppRShift(ELanguage language, List<IToken> tokens) {
        if (!LanguageGroups.C_AND_DERIVATIVES.contains(language)) {
            return false;
        }
        Iterator iterator = TokenStreamUtils.findAll(tokens, (ITokenMatcher)ETokenType.GT).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (tokens.size() == i + 1) {
                return false;
            }
            IToken current = tokens.get(i);
            IToken next = tokens.get(i + 1);
            if (next.getType() != ETokenType.GT || current.getOffset() + 1 != next.getOffset()) continue;
            return true;
        }
        return false;
    }

    private static boolean isObjectMessagingStatement(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        return "simple statement".equals(entity.getSubtype()) && OBJECTIVE_C_MESSAGE_STATEMENT_PATTERN.matchesAnywhere((List)tokens);
    }

    private static boolean hasParentOfSubtype(ShallowEntity entity, String subtype) {
        return entity.getParent() != null && subtype.equalsIgnoreCase(entity.getParent().getSubtype());
    }

    private static boolean isNonCoverableType(ShallowEntity entity, ELanguage language) {
        if (language == ELanguage.JAVASCRIPT && (entity.getType() == EShallowEntityType.META && "commonjs require".equals(entity.getSubtype()) || CoverableStatementUtils.isJavaScriptEnum(language, entity))) {
            return false;
        }
        return !DEFAULT_COVERABLE_ENTITY_TYPES.contains(entity.getType());
    }

    private static boolean isCsExpressionBodiedMethodContent(ShallowEntity entity) {
        ShallowEntity parent = entity.getParent();
        if (parent == null || parent.getType() != EShallowEntityType.METHOD && parent.getType() != EShallowEntityType.ATTRIBUTE) {
            return false;
        }
        IToken lastParentToken = (IToken)CollectionUtils.getLast((List)parent.ownStartTokens());
        return lastParentToken != null && lastParentToken.getType() == ETokenType.DOUBLE_ARROW;
    }

    private static boolean isCsAutoProperty(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.METHOD) {
            return false;
        }
        if (entity.getParent() != null && CoverableStatementUtils.hasParentOfSubtype(entity.getParent(), "interface")) {
            return false;
        }
        String subtype = entity.getSubtype();
        return "empty get".equals(subtype) || "empty set".equals(subtype);
    }

    private static @Nullable Boolean isCppNonCoverableConstantOrInitialization(ShallowEntity entity, List<IToken> tokens) {
        if (CoverableStatementUtils.isCppClassConstant(entity, tokens)) {
            return true;
        }
        if (entity.getChildren().isEmpty() && TokenStreamUtils.containsSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.RBRACE})) {
            return false;
        }
        if (!entity.getChildren().isEmpty() && "simple statement".equals(entity.getSubtype()) && TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.LBRACE)) {
            return true;
        }
        return null;
    }

    private static boolean isCppClassConstant(ShallowEntity entity, List<IToken> tokens) {
        return entity.getType() == EShallowEntityType.ATTRIBUTE && TokenStreamUtils.containsAll(tokens, (ETokenType[])new ETokenType[]{ETokenType.STATIC, ETokenType.CONST});
    }

    private static boolean isJavaScriptNonCoverableDeclaration(ShallowEntity entity) {
        if (entity.getType() == EShallowEntityType.META) {
            return !"commonjs require".equals(entity.getSubtype());
        }
        return CoverableStatementUtils.isJavaScriptEmptyInterfaceAttribute(entity);
    }

    private static boolean isJavaScriptEmptyInterfaceAttribute(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.ATTRIBUTE && entity.getChildren().isEmpty() && CoverableStatementUtils.hasParentOfSubtype(entity, "interface");
    }

    private static boolean isJavaScriptEnum(ELanguage language, ShallowEntity entity) {
        return language == ELanguage.JAVASCRIPT && entity.getType() == EShallowEntityType.TYPE && "enum".equals(entity.getSubtype());
    }

    private static boolean isPrimitiveJavaConstant(List<IToken> tokens) {
        boolean isLiteralAssignment;
        if (tokens.size() < 6) {
            return false;
        }
        if (tokens.get(tokens.size() - 3).getType() != ETokenType.EQ) {
            return false;
        }
        ETokenType assignedValueType = tokens.get(tokens.size() - 2).getType();
        boolean bl = isLiteralAssignment = assignedValueType.isLiteral() || assignedValueType == ETokenType.IDENTIFIER;
        if (!isLiteralAssignment) {
            return false;
        }
        return TokenStreamUtils.containsAll(tokens, (ETokenType[])new ETokenType[]{ETokenType.STATIC, ETokenType.FINAL});
    }

    private static boolean isTopLevelKotlinConstant(ShallowEntity statement, List<IToken> tokens) {
        return statement.getParent() == null && TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.CONST);
    }

    private static boolean isTopLevelGoVariable(ShallowEntity entity) {
        return entity.getParent() == null && CoverableStatementUtils.isGoVariable(entity);
    }

    private static boolean isNonTopLevelGoVariable(ShallowEntity entity) {
        return entity.getParent() != null && CoverableStatementUtils.isGoVariable(entity);
    }

    private static boolean isGoVariable(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.ATTRIBUTE && ("constant".equals(entity.getSubtype()) || "variable".equals(entity.getSubtype()));
    }

    private static boolean isNonCoverableAbapStatement(ShallowEntity statement) {
        String subtype = statement.getSubtype();
        return AbapTypeInfoExtractor.VARIABLE_DECLARATION_SUBTYPES.contains(subtype);
    }

    private static boolean isWhenWithinCase(ShallowEntity element) {
        return "when".equalsIgnoreCase(element.getSubtype()) && CoverableStatementUtils.hasParentOfSubtype(element, "case");
    }

    private CoverableStatementUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

