/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.conqat.engine.sourcecode.coverage.volume.condition.ExpressionTreeBuilder;
import org.conqat.engine.sourcecode.coverage.volume.condition.IOperatorInformation;

public class ExpressionTreeNode {
    private final boolean expandFunctionCalls;
    private final ETokenType[] ternaryOperators = new ETokenType[]{ETokenType.QUESTION, ETokenType.COLON};
    final IOperatorInformation operatorInformation;
    protected ETokenType operator;
    protected ETokenType.ETokenClass tokenClass;
    private List<ExpressionTreeNode> children;
    private ExpressionTreeNode parent;
    protected List<IToken> expression;
    private final boolean couldContainGeneric;
    private final boolean removeParentheses;

    public List<ExpressionTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ExpressionTreeNode> children) {
        this.children = children;
    }

    public List<IToken> getExpression() {
        return this.expression;
    }

    public ExpressionTreeNode(IOperatorInformation operatorInformation, ExpressionTreeNode parent, List<ExpressionTreeNode> children, List<IToken> expression, boolean expandFunctionCalls, boolean couldContainGeneric, boolean removeParentheses) {
        this.operatorInformation = operatorInformation;
        this.parent = parent;
        this.expression = ExpressionTreeBuilder.removeEOLTokens(operatorInformation.preprocessTokens(expression));
        this.removeParentheses = removeParentheses;
        if (removeParentheses && this.expression.size() > 2) {
            this.expression = ExpressionTreeBuilder.removeSurroundingParentheses(this.expression, this.operatorInformation);
        }
        this.children = children;
        this.expandFunctionCalls = expandFunctionCalls;
        this.couldContainGeneric = couldContainGeneric;
    }

    public void expandTree() {
        ExpressionTreeNode.expandTree(this);
    }

    private static void expandTree(ExpressionTreeNode expressionTreeNode) {
        Stack<ExpressionTreeNode> stack = new Stack<ExpressionTreeNode>();
        stack.push(expressionTreeNode);
        ArrayList<ExpressionTreeNode> allNodes = new ArrayList<ExpressionTreeNode>();
        while (!stack.isEmpty()) {
            ExpressionTreeNode node = (ExpressionTreeNode)stack.pop();
            allNodes.add(node);
            if (!node.children.isEmpty()) continue;
            ExpressionTreeNode.parseNode(node);
            node.children.forEach(stack::push);
        }
        for (ExpressionTreeNode node : allNodes.reversed()) {
            if (!node.operatorInformation.isAssociative(node.operator)) continue;
            node.flattenChildren();
        }
    }

    private static void parseNode(ExpressionTreeNode node) {
        if (!node.expression.isEmpty() && node.operatorInformation.openingTypes().contains(node.expression.getFirst().getType()) && TokenStreamUtils.findMatchingClosingToken(node.expression, (int)1, node.operatorInformation.openingTypes(), node.operatorInformation.closingTypes()) == node.expression.size() - 1) {
            node.operator = node.expression.getFirst().getType();
            node.tokenClass = ETokenType.ETokenClass.DELIMITER;
            node.children = List.of(node.createNewNode(ExpressionTreeBuilder.removeSurroundingParentheses(node.expression, node.operatorInformation)));
        } else {
            List<ExpressionTreeNode> operands = node.splitOnOperators();
            if (operands.isEmpty()) {
                node.tokenClass = node.expandFunctionCalls && node.expandFunctionCall() ? ETokenType.ETokenClass.SPECIAL : ETokenType.ETokenClass.LITERAL;
            } else {
                node.children = operands;
            }
        }
    }

    private void flattenChildren() {
        ArrayList<ExpressionTreeNode> flattenedChildren = new ArrayList<ExpressionTreeNode>();
        for (ExpressionTreeNode child : this.children) {
            if (child.operator == this.operator) {
                this.setParentToCurrentNode(child.children);
                flattenedChildren.addAll(child.children);
                continue;
            }
            flattenedChildren.add(child);
        }
        this.children = flattenedChildren;
    }

    private void setParentToCurrentNode(List<ExpressionTreeNode> nodes) {
        for (ExpressionTreeNode child : nodes) {
            child.parent = this;
        }
    }

    private boolean expandFunctionCall() {
        int startIndex = TokenStreamUtils.firstTokenOfTypeSequence(this.expression, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN});
        int endIndex = TokenStreamUtils.findMatchingClosingToken(this.expression, (int)(startIndex + 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (startIndex == -1 || endIndex == -1) {
            return false;
        }
        if (this.isFunctionCallChain(startIndex, endIndex)) {
            return true;
        }
        List<Integer> commaIndices = TokenStreamUtils.getTopLevelCommaIndices(this.expression, (int)(startIndex + 2), (int)(endIndex - 1), this.operatorInformation.openingTypes(), this.operatorInformation.closingTypes());
        if (this.couldContainGeneric) {
            commaIndices = commaIndices.stream().filter(i -> !ExpressionTreeBuilder.getGenericTokens(true, startIndex + 2, endIndex, this.expression, this.operatorInformation).contains(i)).toList();
        }
        this.setChildren(this.getFunctionParameters(commaIndices, startIndex, endIndex));
        return true;
    }

    private boolean isFunctionCallChain(int startIndex, int endIndex) {
        boolean createdFirstChild = false;
        ArrayList<ExpressionTreeNode> newChildren = new ArrayList<ExpressionTreeNode>();
        ++endIndex;
        while (endIndex < this.expression.size() && TokenStreamUtils.startsWith(this.expression.subList(endIndex, this.expression.size()), (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN})) {
            if (!createdFirstChild) {
                createdFirstChild = true;
                newChildren.add(this.createNewNode(this.expression.subList(startIndex, endIndex)));
            }
            if ((endIndex = TokenStreamUtils.findMatchingClosingToken(this.expression, (int)((startIndex = endIndex + 1) + 3), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN)) == -1) {
                return false;
            }
            if (endIndex + 1 <= this.expression.size()) {
                ++endIndex;
            }
            newChildren.add(this.createNewNode(this.expression.subList(startIndex, endIndex)));
        }
        if (createdFirstChild) {
            this.setChildren(newChildren);
        }
        return createdFirstChild;
    }

    private List<ExpressionTreeNode> getFunctionParameters(List<Integer> commaIndices, int startIndex, int endIndex) {
        ArrayList<ExpressionTreeNode> parameters = new ArrayList<ExpressionTreeNode>();
        if (!commaIndices.isEmpty()) {
            int currentCommaIndex = commaIndices.getFirst();
            List<IToken> firstParameter = this.expression.subList(startIndex + 2, currentCommaIndex);
            parameters.add(this.createNewNode(firstParameter));
            for (int i = 0; i < commaIndices.size() - 1; ++i) {
                currentCommaIndex = commaIndices.get(i + 1);
                List<IToken> operand = this.expression.subList(commaIndices.get(i) + 1, currentCommaIndex);
                parameters.add(this.createNewNode(operand));
            }
            List<IToken> lastOperand = this.expression.subList(currentCommaIndex + 1, endIndex);
            parameters.add(this.createNewNode(lastOperand));
        } else {
            List<IToken> firstParameter = this.expression.subList(startIndex + 2, endIndex);
            parameters.add(this.createNewNode(firstParameter));
        }
        return parameters;
    }

    private List<ExpressionTreeNode> splitOnOperators() {
        for (Set<ETokenType> precedenceLevel : this.operatorInformation.operatorsByPrecedence()) {
            List<ExpressionTreeNode> operands = precedenceLevel.isEmpty() ? this.getTernaryExpressionOperands() : ExpressionTreeBuilder.splitExpressionOn(precedenceLevel, ExpressionTreeBuilder.getGenericTokens(this.couldContainGeneric, 0, this.expression.size(), this.expression, this.operatorInformation), this);
            if (operands.isEmpty()) continue;
            return operands;
        }
        return List.of();
    }

    List<ExpressionTreeNode> splitExpressionOn(List<ExpressionTreeNode> operands, int operatorIndex, List<Integer> operatorIndices, boolean operatorWithUniquePrecedence) {
        this.operator = this.expression.get(operatorIndex).getType();
        this.tokenClass = this.operator.getTokenClass();
        if (operatorIndex != 0) {
            if (operatorWithUniquePrecedence) {
                operatorIndex = operatorIndices.getFirst();
            }
            List<IToken> firstOperand = this.expression.subList(0, operatorIndex);
            this.addOperand(operands, firstOperand);
            for (int i = 0; operatorWithUniquePrecedence && (!this.operator.isOperator() || this.operatorInformation.isAssociative(this.operator)) && i < operatorIndices.size() - 1; ++i) {
                operatorIndex = operatorIndices.get(i + 1);
                List<IToken> operand = this.expression.subList(operatorIndices.get(i) + 1, operatorIndex);
                this.addOperand(operands, operand);
            }
        }
        if (operatorIndex + 1 < this.expression.size()) {
            List<IToken> lastOperand = this.expression.subList(operatorIndex + 1, this.expression.size());
            this.addOperand(operands, lastOperand);
        }
        return operands;
    }

    private void addOperand(List<ExpressionTreeNode> operands, List<IToken> operand) {
        int actualOperandTokenNumber = 0;
        for (IToken token : operand) {
            ETokenType tokenType = token.getType();
            if (this.operatorInformation.getAllOperators().contains(tokenType) || this.operatorInformation.openingTypes().contains(tokenType) || this.operatorInformation.closingTypes().contains(tokenType)) continue;
            ++actualOperandTokenNumber;
        }
        if (actualOperandTokenNumber == 0 && !this.operatorInformation.getAllowedEmptyCollections().contains(operand.stream().map(IToken::getType).toList())) {
            return;
        }
        operands.add(this.createNewNode(operand));
    }

    private List<ExpressionTreeNode> getTernaryExpressionOperands() {
        int questionIndex = TokenStreamUtils.findFirstTopLevel(this.expression, (ITokenMatcher)this.ternaryOperators[0], this.operatorInformation.openingTypes(), this.operatorInformation.closingTypes());
        int colonIndex = TokenStreamUtils.findFirstTopLevel(this.expression, (ITokenMatcher)this.ternaryOperators[1], this.operatorInformation.openingTypes(), this.operatorInformation.closingTypes());
        if (questionIndex == -1 || questionIndex >= colonIndex) {
            return List.of();
        }
        ArrayList<ExpressionTreeNode> operands = new ArrayList<ExpressionTreeNode>();
        List<IToken> conditionOperand = this.expression.subList(0, questionIndex);
        operands.add(this.createNewNode(conditionOperand));
        List<IToken> firstReturnOperand = this.expression.subList(questionIndex + 1, colonIndex);
        operands.add(this.createNewNode(firstReturnOperand));
        List<IToken> secondReturnOperand = this.expression.subList(colonIndex + 1, this.expression.size());
        operands.add(this.createNewNode(secondReturnOperand));
        this.tokenClass = ETokenType.ETokenClass.OPERATOR;
        this.operator = this.ternaryOperators[0];
        return operands;
    }

    private ExpressionTreeNode createNewNode(List<IToken> expression) {
        return new ExpressionTreeNode(this.operatorInformation, this, new ArrayList<ExpressionTreeNode>(), expression, this.expandFunctionCalls, this.couldContainGeneric, this.removeParentheses);
    }

    public ETokenType getOperator() {
        return this.operator;
    }

    public ETokenType.ETokenClass getTokenClass() {
        return this.tokenClass;
    }

    public ExpressionTreeNode getParent() {
        return this.parent;
    }

    public boolean isLiteral() {
        return this.getTokenClass() == ETokenType.ETokenClass.LITERAL;
    }

    public boolean isOperator() {
        return this.getTokenClass() == ETokenType.ETokenClass.OPERATOR;
    }

    public boolean isFunction() {
        return this.getTokenClass() == ETokenType.ETokenClass.SPECIAL;
    }

    public String toString() {
        return TokenStreamTextUtils.concatTokenTexts(this.expression);
    }

    public boolean equals(Object other) {
        if (other instanceof ExpressionTreeNode && this.operator == ((ExpressionTreeNode)other).operator) {
            if (this.isLiteral() && ((ExpressionTreeNode)other).isLiteral() || this.tokenClass == ETokenType.ETokenClass.SPECIAL) {
                return TokenStreamTextUtils.getTokenTexts(this.expression).equals(TokenStreamTextUtils.getTokenTexts(((ExpressionTreeNode)other).expression));
            }
            List<ExpressionTreeNode> otherChildren = ((ExpressionTreeNode)other).children;
            if (this.operator != null && this.operatorInformation.isCommutative(this.operator) && this.children.size() == otherChildren.size()) {
                return new HashSet<ExpressionTreeNode>(this.children).containsAll(otherChildren);
            }
            return otherChildren.equals(this.children);
        }
        return false;
    }

    public int hashCode() {
        int result = this.operator != null ? this.operator.hashCode() : 0;
        result = 31 * result + this.tokenClass.hashCode();
        result = this.operatorInformation.isCommutative(this.operator) ? 31 * result + this.children.size() : 31 * result + TokenStreamTextUtils.getTokenTexts(this.expression).hashCode();
        return result;
    }
}

