/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.volume.condition.IOperatorInformation;

public class IOperatorInformationFactory {
    private static final EnumSet<ELanguage> SUPPORTED_LANGUAGES = EnumSet.of(ELanguage.CPP, new ELanguage[]{ELanguage.CPP_MS_CLI, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.PYTHON, ELanguage.CS, ELanguage.KOTLIN});
    private static final List<Set<ETokenType>> CLIKE_OPERATORS = List.of(Set.of(ETokenType.COMMA), Set.of(ETokenType.EQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.ANDEQ, ETokenType.XOREQ, ETokenType.OREQ), Set.of(), Set.of(ETokenType.OROR), Set.of(ETokenType.ANDAND), Set.of(ETokenType.OR), Set.of(ETokenType.XOR), Set.of(ETokenType.AND), Set.of(ETokenType.EQEQ, ETokenType.NOTEQ), Set.of(ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ), Set.of(ETokenType.LSHIFT, ETokenType.RSHIFT, ETokenType.URSHIFT), Set.of(ETokenType.PLUS, ETokenType.MINUS), Set.of(ETokenType.MULT, ETokenType.DIV, ETokenType.MOD), Set.of(ETokenType.NOT, ETokenType.COMP, ETokenType.PLUS, ETokenType.MINUS), Set.of(ETokenType.POWER));
    private static final List<Set<ETokenType>> JAVASCRIPT_OPERATORS = List.of(Set.of(ETokenType.COMMA), Set.of(ETokenType.EQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.ANDEQ, ETokenType.XOREQ, ETokenType.OREQ), Set.of(), Set.of(ETokenType.OROR), Set.of(ETokenType.ANDAND), Set.of(ETokenType.OR), Set.of(ETokenType.XOR), Set.of(ETokenType.AND), Set.of(ETokenType.EQEQ, ETokenType.EQEQEQ, ETokenType.NOTEQ, ETokenType.NOTEQEQ), Set.of(ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ), Set.of(ETokenType.LSHIFT, ETokenType.RSHIFT, ETokenType.URSHIFT), Set.of(ETokenType.PLUS, ETokenType.MINUS), Set.of(ETokenType.MULT, ETokenType.DIV, ETokenType.MOD), Set.of(ETokenType.NOT, ETokenType.COMP, ETokenType.PLUS, ETokenType.MINUS));
    private static final List<Set<ETokenType>> PYTHON_OPERATORS = List.of(Set.of(ETokenType.COMMA), Set.of(ETokenType.EQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.ANDEQ, ETokenType.XOREQ, ETokenType.OREQ), Set.of(ETokenType.OROR), Set.of(ETokenType.ANDAND), Set.of(ETokenType.NOT), Set.of(ETokenType.OR), Set.of(ETokenType.XOR), Set.of(ETokenType.AND), Set.of(ETokenType.IS, ETokenType.IS_NOT, ETokenType.IN, ETokenType.NOT_IN), Set.of(ETokenType.EQEQ, ETokenType.NOTEQ), Set.of(ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ), Set.of(ETokenType.LSHIFT, ETokenType.RSHIFT), Set.of(ETokenType.PLUS, ETokenType.MINUS), Set.of(ETokenType.MULT, ETokenType.DIV, ETokenType.FLOOR_DIV, ETokenType.MOD), Set.of(ETokenType.BIT_NOT), Set.of(ETokenType.POWER));
    private static final List<Set<ETokenType>> CS_OPERATORS = List.of(Set.of(ETokenType.COMMA), Set.of(ETokenType.EQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.ANDEQ, ETokenType.XOREQ, ETokenType.OREQ, ETokenType.DOUBLE_ARROW), Set.of(), Set.of(ETokenType.DOUBLE_QUESTION), Set.of(ETokenType.OROR), Set.of(ETokenType.ANDAND), Set.of(ETokenType.OR), Set.of(ETokenType.XOR), Set.of(ETokenType.AND), Set.of(ETokenType.EQEQ, ETokenType.NOTEQ), Set.of(ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ), Set.of(ETokenType.LSHIFT, ETokenType.RSHIFT, ETokenType.URSHIFT), Set.of(ETokenType.PLUS, ETokenType.MINUS), Set.of(ETokenType.MULT, ETokenType.DIV, ETokenType.MOD), Set.of(ETokenType.NOT, ETokenType.COMP, ETokenType.PLUS, ETokenType.MINUS), Set.of(ETokenType.POWER));
    private static final List<Set<ETokenType>> KOTLIN_OPERATORS = List.of(Set.of(ETokenType.COMMA), Set.of(ETokenType.EQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ), Set.of(ETokenType.OROR), Set.of(ETokenType.ANDAND), Set.of(ETokenType.EQEQ, ETokenType.EQEQEQ, ETokenType.NOTEQ, ETokenType.NOTEQEQ), Set.of(ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ), Set.of(ETokenType.IN, ETokenType.NOT_IN, ETokenType.IS, ETokenType.IS_NOT), Set.of(), Set.of(), Set.of(ETokenType.DOUBLE_DOT), Set.of(ETokenType.PLUS, ETokenType.MINUS), Set.of(ETokenType.MULT, ETokenType.DIV, ETokenType.MOD), Set.of(ETokenType.AS, ETokenType.SAFE_CAST), Set.of(ETokenType.NOT, ETokenType.PLUS, ETokenType.MINUS));

    public static boolean isLanguageSupported(ELanguage language) {
        return SUPPORTED_LANGUAGES.contains(language);
    }

    private static IOperatorInformation getDefaultOperatorInformation(ELanguage language, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        return switch (language) {
            case ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.JAVA -> new OperatorInformation(CLIKE_OPERATORS, openingTypes, closingTypes);
            case ELanguage.JAVASCRIPT -> new OperatorInformation(JAVASCRIPT_OPERATORS, openingTypes, closingTypes);
            case ELanguage.PYTHON -> new OperatorInformation(PYTHON_OPERATORS, openingTypes, closingTypes);
            case ELanguage.CS -> new OperatorInformationWithUnaryOperators(CS_OPERATORS, openingTypes, closingTypes, Set.of(ETokenType.PLUS, ETokenType.MINUS, ETokenType.NOT, ETokenType.XOR, ETokenType.COMP));
            case ELanguage.KOTLIN -> new OperatorInformationWithUnaryOperators(KOTLIN_OPERATORS, openingTypes, closingTypes, Set.of(ETokenType.PLUS, ETokenType.MINUS, ETokenType.NOT, ETokenType.MULT));
            default -> null;
        };
    }

    public static IOperatorInformation getDefaultOperatorInformation(ELanguage language) {
        return IOperatorInformationFactory.getDefaultOperatorInformation(language, List.of(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK), List.of(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK));
    }

    private record OperatorInformation(List<Set<ETokenType>> operatorsByPrecedence, List<ETokenType> openingTypes, List<ETokenType> closingTypes) implements IOperatorInformation
    {
    }

    private record OperatorInformationWithUnaryOperators(List<Set<ETokenType>> operatorsByPrecedence, List<ETokenType> openingTypes, List<ETokenType> closingTypes, Set<ETokenType> unaryOperators) implements IOperatorInformation
    {
    }

    record SimpleOperatorInformation(List<Set<ETokenType>> operatorsByPrecedence) implements IOperatorInformation
    {
    }
}

