/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.pattern;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.sourcecode.pattern.EnumPatternMatcher;
import org.conqat.lib.commons.collections.IntList;

public abstract class EnumPattern<D, E extends Enum<E>> {
    private static final char LITERAL_START = '<';
    private static final char LITERAL_END = '>';
    private static final char CONTENT_PATTERN_DELIMITER = '=';
    private static final char CONTENT_START = '<';
    private static final char CONTENT_END = '>';
    private static final char GROUP_START = '(';
    private static final char GROUP_END = ')';
    private static final String RELUCTANT_SEQUENCE = "*?";
    private static final String WILDCARD = ".";
    private static final String RESTRICTED_WILDCARD = "[^>]";
    private static final char OTHER = '\u00c8';
    private Pattern stringPattern;
    private final Map<Enum<E>, Character> replacements = new HashMap<Enum<E>, Character>();
    private final Class<E> enumType;
    private final String expression;
    private final Set<Enum<E>> contentMatched = new HashSet<Enum<E>>();

    public EnumPattern(Class<E> enumType, String expression) {
        this.expression = expression;
        this.enumType = enumType;
        this.init(expression);
    }

    private void init(String expression) {
        Pattern literalTermPattern = Pattern.compile("<.*?>");
        Matcher literalTermMatcher = literalTermPattern.matcher(expression);
        this.initContentMatched(literalTermMatcher);
        this.buildStringPattern(literalTermMatcher);
    }

    private void initContentMatched(Matcher literalTermMatcher) {
        while (literalTermMatcher.find()) {
            String literalTerm = this.getLiteralTerm(literalTermMatcher);
            int index = literalTerm.indexOf(61);
            if (index < 0) continue;
            String literalName = EnumPattern.extractLiteralName(literalTerm, index);
            E literal = this.getAndCheckLiteral(literalName);
            this.contentMatched.add((Enum<E>)literal);
        }
        literalTermMatcher.reset();
    }

    private static String extractLiteralName(String literalTerm, int index) {
        return literalTerm.substring(0, index);
    }

    private void buildStringPattern(Matcher literalTermMatcher) {
        char current = '\u00c9';
        int last = 0;
        StringBuilder builder = new StringBuilder();
        while (literalTermMatcher.find()) {
            String betweenLiteralTerms = this.expression.substring(last, literalTermMatcher.start());
            builder.append(betweenLiteralTerms);
            String literalTerm = this.getLiteralTerm(literalTermMatcher);
            current = this.processLiteralTerm(builder, literalTerm, current);
            last = literalTermMatcher.end();
        }
        if (last <= this.expression.length()) {
            builder.append(this.expression.substring(last));
        }
        this.stringPattern = Pattern.compile(builder.toString());
        literalTermMatcher.reset();
    }

    private String getLiteralTerm(Matcher literalMatcher) {
        return this.expression.substring(literalMatcher.start() + 1, literalMatcher.end() - 1);
    }

    private char processLiteralTerm(StringBuilder builder, String literalTerm, char current) {
        E literal;
        Character c;
        int index = literalTerm.indexOf(61);
        String contentPattern = null;
        if (index >= 0) {
            contentPattern = literalTerm.substring(index + 1);
            literalTerm = EnumPattern.extractLiteralName(literalTerm, index);
        }
        if ((c = this.getReplacementCharacter((Enum<E>)(literal = this.getAndCheckLiteral(literalTerm)))).charValue() == '\u00c8') {
            char c2 = current;
            current = (char)(current + '\u0001');
            c = Character.valueOf(c2);
            this.addReplacementCharacter((Enum<E>)literal, c.charValue());
        }
        this.appendReplacement(builder, (Enum<E>)literal, c, contentPattern);
        return current;
    }

    private Character getReplacementCharacter(Enum<E> e) {
        Character c = this.replacements.get(e);
        if (c == null) {
            c = Character.valueOf('\u00c8');
        }
        return c;
    }

    private void addReplacementCharacter(Enum<E> literal, char c) {
        this.replacements.put(literal, Character.valueOf(c));
    }

    private void appendReplacement(StringBuilder builder, Enum<E> enumValue, Character c, String contentPattern) {
        if (this.contentMatched.contains(enumValue)) {
            builder.append('(');
            builder.append(c);
            builder.append('<');
            if (contentPattern != null) {
                contentPattern = EnumPattern.restrictWildcard(contentPattern);
                Pattern.compile(contentPattern);
                builder.append(contentPattern);
            } else {
                builder.append("[^>]*?");
            }
            builder.append('>');
            builder.append(')');
        } else {
            builder.append(c);
        }
    }

    private static String restrictWildcard(String contentPattern) {
        StringBuilder builder = new StringBuilder(contentPattern);
        int i = builder.indexOf(WILDCARD);
        while (i >= 0) {
            if (i == 0 || builder.charAt(i - 1) != '\\') {
                builder.replace(i, i + 1, RESTRICTED_WILDCARD);
            }
            i = builder.indexOf(WILDCARD, i + 1);
        }
        return builder.toString();
    }

    public EnumPatternMatcher matcher(List<D> sequence) {
        StringBuilder builder = new StringBuilder();
        IntList positions = this.convertSequence(builder, sequence);
        return new EnumPatternMatcher(this, builder.toString(), positions);
    }

    private IntList convertSequence(StringBuilder builder, List<D> sequence) {
        IntList positions = this.createPositions();
        for (D element : sequence) {
            E e = this.getEnum(element);
            Character c = this.getReplacementCharacter((Enum<E>)e);
            this.addCurrentPosition(positions, builder);
            builder.append(c);
            if (!this.contentMatched.contains(e)) continue;
            builder.append("<" + this.getContent(element) + ">");
        }
        this.addCurrentPosition(positions, builder);
        return positions;
    }

    private IntList createPositions() {
        IntList positions = null;
        if (!this.contentMatched.isEmpty()) {
            positions = new IntList();
        }
        return positions;
    }

    private void addCurrentPosition(IntList positions, StringBuilder builder) {
        if (!this.contentMatched.isEmpty()) {
            positions.add(builder.length());
        }
    }

    protected abstract E getEnum(D var1);

    protected abstract String getContent(D var1);

    private E getAndCheckLiteral(String enumName) {
        try {
            return Enum.valueOf(this.enumType, enumName);
        }
        catch (IllegalArgumentException e) {
            throw new PatternSyntaxException(e.getMessage(), this.expression, this.expression.indexOf(enumName));
        }
    }

    public String getExpression() {
        return this.expression;
    }

    Pattern getPattern() {
        return this.stringPattern;
    }
}

