/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import ru.bozaro.gitlfs.client.internal.LfsRequest;
import ru.bozaro.gitlfs.client.internal.Request;
import ru.bozaro.gitlfs.client.io.StreamHandler;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001d\u0010\f\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/bozaro/gitlfs/client/internal/ObjectGet;", "T", "Lru/bozaro/gitlfs/client/internal/Request;", "handler", "Lru/bozaro/gitlfs/client/io/StreamHandler;", "(Lru/bozaro/gitlfs/client/io/StreamHandler;)V", "createRequest", "Lru/bozaro/gitlfs/client/internal/LfsRequest;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "url", "", "processResponse", "response", "Lorg/apache/http/HttpResponse;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/apache/http/HttpResponse;)Ljava/lang/Object;", "gitlfs-client"})
public final class ObjectGet<T>
implements Request<T> {
    @NotNull
    private final StreamHandler<T> handler;

    public ObjectGet(@NotNull StreamHandler<T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.handler = handler;
    }

    @Override
    @NotNull
    public LfsRequest createRequest(@NotNull ObjectMapper mapper, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpGet req = new HttpGet(url);
        return new LfsRequest((HttpUriRequest)req, null);
    }

    @Override
    public T processResponse(@NotNull ObjectMapper mapper, @NotNull HttpResponse response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        InputStream inputStream = response.getEntity().getContent();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"response.entity.content");
        return this.handler.accept(inputStream);
    }

    @Override
    @NotNull
    public int[] statusCodes() {
        return Request.DefaultImpls.statusCodes(this);
    }
}

