/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum SuppressType {
    LAST_ACCESS_TIME(0),
    LAST_LOGIN_TIME(1),
    LAST_LOGIN_IP(2),
    LASTMOD(3);

    private final int intValue;

    private SuppressType(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    @Nullable
    public static SuppressType valueOf(int intValue) {
        for (SuppressType t : SuppressType.values()) {
            if (t.intValue != intValue) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static SuppressType forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "lastaccesstime": 
            case "last-access-time": 
            case "last_access_time": {
                return LAST_ACCESS_TIME;
            }
            case "lastlogintime": 
            case "last-login-time": 
            case "last_login_time": {
                return LAST_LOGIN_TIME;
            }
            case "lastloginip": 
            case "last-login-ip": 
            case "last_login_ip": {
                return LAST_LOGIN_IP;
            }
            case "lastmod": {
                return LASTMOD;
            }
        }
        return null;
    }
}

