/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui;

import com.teamscale.core.permissions.ServicePermissions;
import jakarta.ws.rs.core.UriBuilder;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.js_export.NotExported;

@ExportToTypeScript
public enum ETeamscalePerspective {
    DASHBOARD("Dashboard", "dashboard", "show", true, "image outline"),
    ACTIVITY("Activity", "activity", "commits", true, "code branch"),
    FINDINGS("Findings", "findings", "list", true, "exclamation triangle"),
    METRICS("Metrics", "metrics", "code", true, "percent"),
    REQUIREMENTS_TRACING("Requirements Tracing", "requirements-tracing", "overview", true, "exchange"),
    TEST_GAPS("Test Gaps", "testgaps", "code", true, "object group outline"),
    QUALITY_CONTROL("Quality Control", "qualitycontrol", "reports", true, "check circle outline"),
    AUDIT("Audit", "audit", "file-summary", true, ServicePermissions::mayAccessAuditPerspective, "eye"),
    COMPARE("Compare", "compare", "code", false, ""),
    MODEL_COMPARE("Model Compare", "model-compare", "compare", false, ""),
    ARCHITECTURE("Architecture", "architecture", "architecture", true, "sitemap"),
    DELTA("Delta", "delta", "input", true, "chartline"),
    PROJECTS("Project Configuration", "project", "project", true, ServicePermissions::mayAccessProjectsPerspective, "sun outline"),
    SYSTEM("System", "system", "execution", true, ServicePermissions::mayViewSystemStatus, "hdd outline"),
    ADMIN("Admin", "admin", "options", true, permissions -> permissions.mayAccessAdminPerspective() || permissions.mayAccessProjectsPerspective() && permissions.hasAdminPerspectiveSubviewAccess(), "hashtag"),
    SEARCH("Search", "search", "search", false, ""),
    USER("Users", "user", "show", false, ""),
    API_DOCUMENTATION("API Documentation", "api", "public", false, ""),
    CHECKS("Checks", "checks", "checks", false, ""),
    SNIPPET_ANALYSIS("Snippet Analysis", "snippet_analysis", "snippet-analysis", false, "");

    public static final ETeamscalePerspective DEFAULT;
    private final String displayName;
    private final String simpleName;
    @NotExported
    private final String defaultViewName;
    private final boolean visible;
    private final String iconClass;
    @NotExported
    private final IPerspectiveVisibilityCheck visibilityCheck;

    private ETeamscalePerspective(String displayName, String simpleName, String defaultViewName, boolean visible, String iconClass) {
        this(displayName, simpleName, defaultViewName, visible, permissions -> true, iconClass);
    }

    private ETeamscalePerspective(String displayName, String simpleName, String defaultViewName, boolean visible, IPerspectiveVisibilityCheck visibilityCheck, String iconClass) {
        this.displayName = displayName;
        this.simpleName = simpleName;
        this.defaultViewName = defaultViewName;
        this.visible = visible;
        this.visibilityCheck = visibilityCheck;
        this.iconClass = iconClass;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isUserVisible(ServicePermissions permissions) throws StorageException {
        return this.visibilityCheck.isUserVisible(permissions);
    }

    public UriBuilder createUri() {
        return this.createUri(this.defaultViewName);
    }

    public UriBuilder createUri(String viewName) {
        return UriBuilder.newInstance().segment(new String[]{this.simpleName}).segment(new String[]{viewName});
    }

    public UriBuilder createUri(String viewName, PublicProjectId project) {
        return this.createUri(viewName).segment(new String[]{project.toString()});
    }

    public UriBuilder createUri(String viewName, PublicProjectId project, String uniformPath) {
        return this.createUri(viewName, project).segment(new String[]{uniformPath});
    }

    static {
        DEFAULT = DASHBOARD;
    }

    @FunctionalInterface
    public static interface IPerspectiveVisibilityCheck {
        public boolean isUserVisible(ServicePermissions var1) throws StorageException;
    }
}

