/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.comparison;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryExamples;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.conqat.lib.commons.diff.DiffDescription;
import org.conqat.lib.commons.diff.LineBasedDiffer;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class PredefinedImprovedInstanceComparisonDiffEntry
extends InstanceComparisonDiffEntryBase<String> {
    private static final Pattern CONCATENATED_MARKDOWN_HIGHLIGHTS = Pattern.compile("](\\s+)\\[");
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="onlyImprovement")
    protected final boolean onlyImprovement;

    @JsonCreator
    public PredefinedImprovedInstanceComparisonDiffEntry(@JsonProperty(value="name") String name, @JsonProperty(value="localValue") String localValue, @JsonProperty(value="remoteValue") String remoteValue, @JsonProperty(value="examples") InstanceComparisonDiffEntryExamples examples, @JsonProperty(value="onlyImprovement") boolean onlyImprovement, @JsonProperty(value="withinAcceptedDeviations") boolean withinAcceptedDeviations) {
        super(name, examples, localValue, remoteValue, withinAcceptedDeviations);
        this.onlyImprovement = onlyImprovement;
    }

    public static PredefinedImprovedInstanceComparisonDiffEntry fromObject(String name, Object localValue, Object remoteValue, boolean onlyImprovement) {
        return PredefinedImprovedInstanceComparisonDiffEntry.fromObject(name, localValue, remoteValue, InstanceComparisonDiffEntryExamples.EMPTY, onlyImprovement, false);
    }

    public static PredefinedImprovedInstanceComparisonDiffEntry fromObject(String name, Object localValue, Object remoteValue, InstanceComparisonDiffEntryExamples examples, boolean onlyImprovement, boolean withinAcceptedDeviations) {
        return PredefinedImprovedInstanceComparisonDiffEntry.fromObject(name, localValue, remoteValue, examples, onlyImprovement, withinAcceptedDeviations, true);
    }

    public static PredefinedImprovedInstanceComparisonDiffEntry fromObject(String name, Object localValue, Object remoteValue, InstanceComparisonDiffEntryExamples examples, boolean onlyImprovement, boolean withinAcceptedDeviations, boolean ignoreWhitespace) {
        String local = String.valueOf(localValue);
        String remote = String.valueOf(remoteValue);
        if (localValue != null && remoteValue != null) {
            DiffDescription diff = PredefinedImprovedInstanceComparisonDiffEntry.performDiff(local, remote, ignoreWhitespace);
            local = PredefinedImprovedInstanceComparisonDiffEntry.highlightChangeRegions(local, (List<Integer>)diff.getLeftChangeRegions());
            remote = PredefinedImprovedInstanceComparisonDiffEntry.highlightChangeRegions(remote, (List<Integer>)diff.getRightChangeRegions());
        }
        if (localValue == null) {
            local = "<not found>";
        }
        if (remoteValue == null) {
            remote = "<not found>";
        }
        return new PredefinedImprovedInstanceComparisonDiffEntry(name, local, remote, examples, onlyImprovement, withinAcceptedDeviations);
    }

    private static DiffDescription performDiff(String local, String remote, boolean ignoreWhitespace) {
        LineBasedDiffer differ = new LineBasedDiffer(ignoreWhitespace);
        return differ.performDiff((Object)local, (Object)remote);
    }

    private static String highlightChangeRegions(String text, List<Integer> changeRegions) {
        if (changeRegions.isEmpty()) {
            return StringUtils.escapeMarkdownChars((String)text);
        }
        Preconditions.checkArgument((changeRegions.size() % 2 == 0 ? 1 : 0) != 0, (String)"Invalid change regions given (must be even): %s", changeRegions);
        StringBuilder newValue = new StringBuilder();
        newValue.append(StringUtils.escapeMarkdownChars((String)text.substring(0, changeRegions.get(0))));
        for (int i = 0; i < changeRegions.size() - 1; i += 2) {
            int regionStart = changeRegions.get(i);
            int regionEnd = changeRegions.get(i + 1);
            if (i > 0) {
                int previousRegionEnd = changeRegions.get(i - 1);
                newValue.append(StringUtils.escapeMarkdownChars((String)text.substring(previousRegionEnd, regionStart)));
            }
            newValue.append("[");
            newValue.append(StringUtils.escapeMarkdownChars((String)text.substring(regionStart, regionEnd)));
            newValue.append("]");
        }
        newValue.append(StringUtils.escapeMarkdownChars((String)text.substring((Integer)Iterables.getLast(changeRegions))));
        return StringUtils.replaceAll((String)newValue.toString(), (Pattern)CONCATENATED_MARKDOWN_HIGHLIGHTS, (String)"$1");
    }

    @Override
    public boolean isOnlyImprovement() {
        return this.onlyImprovement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredefinedImprovedInstanceComparisonDiffEntry that = (PredefinedImprovedInstanceComparisonDiffEntry)o;
        return this.onlyImprovement == that.onlyImprovement && this.withinAcceptedDeviations == that.withinAcceptedDeviations && Objects.equals(this.localValue, that.localValue) && Objects.equals(this.remoteValue, that.remoteValue);
    }

    public int hashCode() {
        return Objects.hash(this.localValue, this.remoteValue, this.onlyImprovement, this.withinAcceptedDeviations);
    }

    public String toString() {
        return "PredefinedImprovedInstanceComparisonDiffEntry{onlyImprovement=" + this.onlyImprovement + ", name='" + this.name + "', examples=" + String.valueOf(this.examples) + ", localValue=" + (String)this.localValue + ", remoteValue=" + (String)this.remoteValue + ", withinAcceptedDeviations=" + this.withinAcceptedDeviations + "}";
    }
}

