/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.index.admin.instance_comparison.EInstanceComparisonStatus;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotCreationOptions;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotMetaData;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.global.GlobalComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributionBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.conqat.lib.commons.version.Version;
import org.jspecify.annotations.Nullable;

public record InstanceComparisonSnapshotDto(@JsonProperty(value="id") String id, @JsonProperty(value="status") EInstanceComparisonStatus status, @JsonProperty(value="options") InstanceComparisonSnapshotCreationOptions options, @JsonProperty(value="globalComparisonInputs") List<GlobalComparisonContributionBase> globalComparisonInputs, @JsonProperty(value="projectComparisonInputs") List<ProjectComparisonContributionBase> projectComparisonInputs, @JsonProperty(value="error") @Nullable String error, @JsonProperty(value="createdOn") long createdOn, @JsonProperty(value="instanceName") String instanceName, @JsonProperty(value="teamscaleVersion") @Nullable Version teamscaleVersion) {
    public static InstanceComparisonSnapshotDto of(InstanceComparisonSnapshotMetaData metaData, InstanceComparisonSnapshotContributions contributions) {
        return new InstanceComparisonSnapshotDto(metaData.getId(), metaData.getStatus(), metaData.getOptions(), contributions.globalComparisonInputs(), contributions.projectComparisonInputs(), metaData.getError(), metaData.getCreatedOn(), metaData.getInstanceName(), ETeamscaleVersion.CURRENT_VERSION.toVersionObject());
    }

    public List<InstanceComparisonContributionBase> getAllComparisonInputs() {
        return Stream.of(this.globalComparisonInputs, this.projectComparisonInputs).flatMap(Collection::stream).toList();
    }

    public record InstanceComparisonSnapshotContributions(List<GlobalComparisonContributionBase> globalComparisonInputs, List<ProjectComparisonContributionBase> projectComparisonInputs) {
        public static final InstanceComparisonSnapshotContributions EMPTY = new InstanceComparisonSnapshotContributions(Collections.emptyList(), Collections.emptyList());

        public static InstanceComparisonSnapshotContributions of(Collection<? extends InstanceComparisonContributionBase> contributions) {
            ArrayList<GlobalComparisonContributionBase> globalComparisonInputs = new ArrayList<GlobalComparisonContributionBase>();
            ArrayList<ProjectComparisonContributionBase> projectComparisonInputs = new ArrayList<ProjectComparisonContributionBase>();
            for (InstanceComparisonContributionBase instanceComparisonContributionBase : contributions) {
                if (instanceComparisonContributionBase instanceof ProjectComparisonContributionBase) {
                    ProjectComparisonContributionBase projectContribution = (ProjectComparisonContributionBase)instanceComparisonContributionBase;
                    projectComparisonInputs.add(projectContribution);
                    continue;
                }
                if (instanceComparisonContributionBase instanceof GlobalComparisonContributionBase) {
                    GlobalComparisonContributionBase globalContribution = (GlobalComparisonContributionBase)instanceComparisonContributionBase;
                    globalComparisonInputs.add(globalContribution);
                    continue;
                }
                throw new UnsupportedOperationException("Contribution %s is of type %s, which is neither %s nor %s".formatted(instanceComparisonContributionBase, instanceComparisonContributionBase.getClass(), ProjectComparisonContributionBase.class, GlobalComparisonContributionBase.class));
            }
            return new InstanceComparisonSnapshotContributions(globalComparisonInputs, projectComparisonInputs);
        }

        public List<InstanceComparisonContributionBase> getAllComparisonInputs() {
            return Stream.of(this.globalComparisonInputs, this.projectComparisonInputs).flatMap(Collection::stream).toList();
        }
    }
}

