/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.global;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.DetailedInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public class MaintenanceLogErrorsComparisonDetailContribution
implements IDetailedInstanceComparisonContribution {
    private static final long serialVersionUID = 1L;
    private static final String LOG_TIMESTAMPS_FOR_TRIGGER_PROPERTY = "logTimestampsForTrigger";
    @JsonProperty(value="logTimestampsForTrigger")
    private final @NonNull Map<String, Set<Long>> logTimestampsForTrigger;

    @JsonCreator
    MaintenanceLogErrorsComparisonDetailContribution(@JsonProperty(value="logTimestampsForTrigger") @NonNull Map<String, Set<Long>> logTimestampsForTrigger) {
        CCSMAssert.isNotNull(logTimestampsForTrigger, () -> "Expected \"logTimestampsForTrigger\" to be not null");
        this.logTimestampsForTrigger = logTimestampsForTrigger;
    }

    public MaintenanceLogErrorsComparisonDetailContribution() {
        this.logTimestampsForTrigger = new HashMap<String, Set<Long>>();
    }

    public void addLogEntry(ShortWorkerLog log) {
        this.logTimestampsForTrigger.computeIfAbsent(log.getTriggerName(), ignored -> new HashSet()).add(log.getTimestamp());
    }

    @Override
    public @NonNull Map<String, DetailedInstanceComparisonValue> getDetailedValues(String trigger) {
        return this.logTimestampsForTrigger.getOrDefault(trigger, Collections.emptySet()).stream().collect(Collectors.toMap(String::valueOf, logTimestamp -> DetailedInstanceComparisonValue.ofMaintenanceLogError(trigger, logTimestamp), CollectionUtils.throwingMerger(DetailedInstanceComparisonValue::getHumanReadable), () -> new TreeMap(Comparator.comparingLong(Long::parseLong))));
    }
}

