/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.user.User;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.IComparisonContributorContext;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributorBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.SpecItemComparisonContribution;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class SpecItemComparisonContributor
extends ProjectComparisonContributorBase {
    private static final int SPEC_ITEM_BATCH_SIZE = 1000;

    public SpecItemComparisonContributor(IComparisonContributorContext.ProjectContext context) {
        super(context);
    }

    @Override
    public SpecItemComparisonContribution createComparisonInput() throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.getProjectStorageSystem();
        PairList<String, EKeyedObjectType> knownColumns = this.getKnownColumns((ProjectStorageSystem)projectStorageSystem);
        List<HashEntry> specItemHash = this.computeSpecItemHash((ProjectStorageSystem)projectStorageSystem, knownColumns);
        Map<String, Object> specItemMetrics = this.getSpecItemMetrics((ProjectStorageSystem)projectStorageSystem);
        return new SpecItemComparisonContribution("Spec Items", ((IComparisonContributorContext.ProjectContext)this.context).publicProjectId().toString(), knownColumns.toString(), specItemHash, specItemMetrics);
    }

    private PairList<String, EKeyedObjectType> getKnownColumns(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return WorkItemHistoryIndexAggregation.forSpecItems(projectStorageSystem, this.getHistoryAccessOption()).getKnownColumns();
    }

    private List<HashEntry> computeSpecItemHash(ProjectStorageSystem projectStorageSystem, PairList<String, EKeyedObjectType> knownColumns) throws StorageException {
        ArrayList<HashEntry> hashEntries = new ArrayList<HashEntry>();
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((MetaIndex)((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)));
        List requirementConnectors = ProjectConfigurationUtils.getRequirementConnectors((ProjectConfiguration)projectConfiguration);
        for (ConnectorConfiguration connector : requirementConnectors) {
            List<TeamscaleIssueId> allSpecItemsIdsForConnector = this.getAllSpecItemIdsForConnector(projectStorageSystem, connector);
            hashEntries.addAll(this.computeHashForConnector(projectStorageSystem, connector, allSpecItemsIdsForConnector, knownColumns));
        }
        return hashEntries;
    }

    private List<TeamscaleIssueId> getAllSpecItemIdsForConnector(ProjectStorageSystem projectStorageSystem, ConnectorConfiguration connector) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)SpecItemIndex.matchRequirementsManagementConnectorIdToBranchName(connector.getIdentifier()), (long)((IComparisonContributorContext.ProjectContext)this.context).endTimestamp());
        SpecItemIndex specItemIndex = (SpecItemIndex)projectStorageSystem.openProjectIndex(SpecItemIndex.class, historyAccessOption);
        return specItemIndex.getAllKeys();
    }

    private List<HashEntry> computeHashForConnector(ProjectStorageSystem projectStorageSystem, ConnectorConfiguration connector, List<TeamscaleIssueId> allSpecItemsIdsForConnector, PairList<String, EKeyedObjectType> knownColumns) throws StorageException {
        ArrayList<HashEntry> hashEntries = new ArrayList<HashEntry>();
        for (List batch : Lists.partition(allSpecItemsIdsForConnector, (int)1000)) {
            hashEntries.addAll(this.computeHashForSublist(projectStorageSystem, connector, batch, knownColumns));
        }
        return hashEntries;
    }

    private List<HashEntry> computeHashForSublist(ProjectStorageSystem projectStorageSystem, ConnectorConfiguration connector, List<TeamscaleIssueId> specItemIds, PairList<String, EKeyedObjectType> knownColumns) throws StorageException {
        List<SpecItem> specItems = this.getSpecItemsFromIds(projectStorageSystem, connector, specItemIds);
        if (specItems.isEmpty()) {
            return new ArrayList<HashEntry>();
        }
        return specItems.stream().map(item -> this.calculateHashEntry((SpecItem)item, knownColumns)).toList();
    }

    private HashEntry calculateHashEntry(SpecItem item, PairList<String, EKeyedObjectType> knownColumns) {
        String firstClassValues = knownColumns.getFirstList().stream().map(arg_0 -> ((SpecItem)item).getStringValueByPropertyName(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(","));
        return new HashEntry(item.getId(), SpecItemComparisonContributor.hashContent(firstClassValues), SpecItemComparisonContributor.hashContent(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)item.getAdditionalFieldValues())));
    }

    private List<SpecItem> getSpecItemsFromIds(ProjectStorageSystem projectStorageSystem, ConnectorConfiguration connector, List<TeamscaleIssueId> specItemIds) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)SpecItemIndex.matchRequirementsManagementConnectorIdToBranchName(connector.getIdentifier()), (long)((IComparisonContributorContext.ProjectContext)this.context).endTimestamp());
        SpecItemIndex specItemIndex = (SpecItemIndex)projectStorageSystem.openProjectIndex(SpecItemIndex.class, historyAccessOption);
        return specItemIndex.getIssues(specItemIds);
    }

    private static String hashContent(String string) {
        return Hashing.murmur3_128().newHasher().putString((CharSequence)string, Charsets.UTF_8).hash().toString();
    }

    private Map<String, Object> getSpecItemMetrics(ProjectStorageSystem projectStorageSystem) throws StorageException {
        IMetricRetrievalStrategy strategy = this.getMetricRetrievalStrategy(projectStorageSystem);
        MetricDirectoryEntry metricDirectoryEntry = strategy.getMetricDirectoryEntry(UniformPath.specItemQueryRoot(), this.getHistoryAccessOption());
        if (metricDirectoryEntry == null) {
            return new HashMap<String, Object>();
        }
        UnmodifiableList metricDirectorySchemaEntries = strategy.getMetricDirectorySchema().getAllEntries();
        HashMap<String, Object> specItemMetrics = new HashMap<String, Object>();
        for (int i = 0; i < metricDirectorySchemaEntries.size(); ++i) {
            MetricDirectorySchemaEntry entry = (MetricDirectorySchemaEntry)metricDirectorySchemaEntries.get(i);
            specItemMetrics.put("All items: " + entry.getName(), metricDirectoryEntry.getValue(i));
        }
        return specItemMetrics;
    }

    private IMetricRetrievalStrategy getMetricRetrievalStrategy(ProjectStorageSystem projectStorageSystem) throws StorageException {
        User user = new User("", "", "", "", "");
        return MetricRetrievalStrategyFactory.getStrategy(UniformPath.EType.SPEC_ITEM_QUERY, projectStorageSystem, this.getGlobalStorageSystem(), user);
    }

    @IndexValueClass
    public record HashEntry(TeamscaleIssueId specItemId, String firstClassFieldHash, String additionalFieldsHash) implements Serializable
    {
    }
}

