/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.worker.ProjectWorkerLogIndex;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.IComparisonContributorContext;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.LogErrorsComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributorBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.WorkerLogErrorsComparisonDetailContribution;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;

public class WorkerLogErrorsComparisonContributor
extends ProjectComparisonContributorBase {
    public static final String WORKER_LOG_CONTRIBUTOR = "Worker Log Errors";

    public WorkerLogErrorsComparisonContributor(IComparisonContributorContext.ProjectContext context) {
        super(context);
    }

    @Override
    public LogErrorsComparisonContribution createComparisonInput() throws StorageException {
        ProjectWorkerLogIndex logIndex = (ProjectWorkerLogIndex)this.getProjectStorageSystem().openProjectIndex(ProjectWorkerLogIndex.class, null);
        List workerLogErrors = logIndex.getEntries(LogIndexBase.EIndexLogLevel.ERROR, 0L, ((IComparisonContributorContext.ProjectContext)this.context).endTimestamp());
        workerLogErrors.addAll(logIndex.getEntries(LogIndexBase.EIndexLogLevel.FATAL, 0L, ((IComparisonContributorContext.ProjectContext)this.context).endTimestamp()));
        CounterSet errorFrequencies = (CounterSet)workerLogErrors.stream().collect(CounterSet.toCounterSet(ShortWorkerLog::getTriggerName, entry -> entry.getLogCount().errorAndFatal()));
        WorkerLogErrorsComparisonDetailContribution detailContribution = null;
        if (((IComparisonContributorContext.ProjectContext)this.context).detailed()) {
            detailContribution = new WorkerLogErrorsComparisonDetailContribution();
            workerLogErrors.forEach(detailContribution::add);
        }
        return new LogErrorsComparisonContribution(WORKER_LOG_CONTRIBUTOR, ((IComparisonContributorContext.ProjectContext)this.context).publicProjectId().toString(), (CounterSet<String>)errorFrequencies, detailContribution);
    }
}

