/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.profiler;

import com.teamscale.index.admin.profiler.EProfilerHealth;
import com.teamscale.index.admin.profiler.EProfilerStatus;
import com.teamscale.index.admin.profiler.ProcessInformation;
import com.teamscale.index.admin.profiler.ProfilerConfiguration;
import com.teamscale.index.admin.profiler.ProfilerInfo;
import java.io.Serializable;
import java.time.Duration;
import java.util.UUID;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public record RunningProfilerInfo(UUID id, ProfilerInfo profilerInfo, long lastHeartbeatTimestamp, boolean hasShutDown, EProfilerHealth health, @Nullable String failureMessage) implements Serializable
{
    private static final Duration OFFLINE_THRESHOLD = Duration.ofSeconds(90L);

    public EProfilerStatus getStatus() {
        if (this.hasShutDown) {
            return EProfilerStatus.SHUTDOWN;
        }
        if (DurationUtils.elapsed((Duration)OFFLINE_THRESHOLD, (long)this.lastHeartbeatTimestamp)) {
            return EProfilerStatus.OFFLINE;
        }
        return EProfilerStatus.ONLINE;
    }

    public RunningProfilerInfo withHeartbeatNow() {
        return new RunningProfilerInfo(this.id, this.profilerInfo, DateTimeUtils.millisNow(), false, this.health, this.failureMessage);
    }

    public RunningProfilerInfo withShutdownNow() {
        long now = DateTimeUtils.millisNow();
        ProfilerInfo newProfilerInfo = new ProfilerInfo(this.profilerInfo.processInformation().withStoppedAt(now), this.profilerInfo.profilerConfiguration());
        return new RunningProfilerInfo(this.id, newProfilerInfo, now, true, this.health, this.failureMessage);
    }

    public RunningProfilerInfo withHealth(EProfilerHealth profilerHealth) {
        return new RunningProfilerInfo(this.id, this.profilerInfo, this.lastHeartbeatTimestamp, this.hasShutDown, profilerHealth, this.failureMessage);
    }

    public RunningProfilerInfo withFailure(String failureMessage) {
        return new RunningProfilerInfo(this.id, this.profilerInfo, this.lastHeartbeatTimestamp, this.hasShutDown, failureMessage == null ? this.health : EProfilerHealth.CRITICAL, failureMessage == null ? this.failureMessage : failureMessage);
    }

    public RunningProfilerInfo withId(UUID id) {
        return new RunningProfilerInfo(id, this.profilerInfo, this.lastHeartbeatTimestamp, this.hasShutDown, this.health, this.failureMessage);
    }

    public static RunningProfilerInfo makeNewlyRegistered(ProcessInformation processInformation, ProfilerConfiguration profilerConfiguration) {
        UUID profilerId = UUID.randomUUID();
        return new RunningProfilerInfo(profilerId, new ProfilerInfo(processInformation, profilerConfiguration), DateTimeUtils.millisNow(), false, EProfilerHealth.OK, null);
    }
}

