/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.apple.idms.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import java.time.DateTimeException;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;

public record AppleA3Token(@JsonProperty(value="token") String token) {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String INVALID_TOKEN_FORMAT_ERROR = "A3 token format incorrect. Not logging by default, as this is an authentication secret. Turn on debug logging for more information.";

    private Instant parseExpiryTimestamp() {
        String[] parts = this.token.split(":");
        LOGGER.debug("Parsing A3 token '{}' with expected format 'A3 Token = <HMAC Token>:<nonce>:<Expiry Timestamp>:<Context Version>'", (Object)this.token);
        CCSMAssert.isTrue((parts.length == 4 ? 1 : 0) != 0, (String)INVALID_TOKEN_FORMAT_ERROR);
        String timestamp = parts[2];
        try {
            return Instant.ofEpochMilli(Long.parseLong(timestamp));
        }
        catch (NumberFormatException | DateTimeException e) {
            throw new AssertionError(INVALID_TOKEN_FORMAT_ERROR, e);
        }
    }

    public AccessTokenIndex.AccessToken toAccessToken() {
        return new AccessTokenIndex.AccessToken(this.token, this.parseExpiryTimestamp());
    }
}

