/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.ListMap;

public interface ITypeToFileLookup {
    public static ITypeToFileLookup create(ArchitectureDefinition architectureDefinition, ListMap<String, String> typeToFilesLookup) {
        if (architectureDefinition.isFileBased()) {
            return new IdentityTypeLookup(typeToFilesLookup);
        }
        return new TypeToFileLookup(typeToFilesLookup);
    }

    public List<String> getFilesForType(String var1);

    public Set<String> getAllFiles();

    public static class IdentityTypeLookup
    extends TypeToFileLookup {
        private IdentityTypeLookup(ListMap<String, String> typeToFilesLookup) {
            super(typeToFilesLookup);
        }

        @Override
        public List<String> getFilesForType(String type) {
            return Collections.singletonList(type);
        }
    }

    public static class TypeToFileLookup
    implements ITypeToFileLookup {
        private final ListMap<String, String> typeToFilesLookup;
        private final Set<String> files;

        private TypeToFileLookup(ListMap<String, String> typeToFilesLookup) {
            this.typeToFilesLookup = typeToFilesLookup;
            this.files = new HashSet<String>(typeToFilesLookup.getValues());
        }

        @Override
        public List<String> getFilesForType(String type) {
            return (List)this.typeToFilesLookup.getCollectionOrEmpty((Object)type);
        }

        @Override
        public Set<String> getAllFiles() {
            return this.files;
        }
    }
}

