/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.google.common.collect.Iterables;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentInfo;
import com.teamscale.index.architecture.ArchitectureAssessmentInfoUtils;
import com.teamscale.index.architecture.ArchitectureFindingCreator;
import com.teamscale.index.architecture.ArchitectureReferenceIndex;
import com.teamscale.index.architecture.ITypeToFileLookup;
import com.teamscale.index.architecture.assessment.ArchitectureAnnotator;
import com.teamscale.index.architecture.assessment.shared.Dependency;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import com.teamscale.index.architecture.incremental.ArchitectureAnalysisUtils;
import com.teamscale.index.architecture.incremental.ArchitectureComponentDependencyIndex;
import com.teamscale.index.architecture.incremental.ArchitectureFileDependenciesIndex;
import com.teamscale.index.architecture.incremental.ArchitectureMappingIndex;
import com.teamscale.index.architecture.incremental.ArchitectureTypeDependenciesIndex;
import com.teamscale.index.architecture.incremental.DependencyValueClass;
import com.teamscale.index.architecture.incremental.IArchitectureScopeIndex;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ArchitectureDefinitionReader;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.dependencies.DependencyListIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class IndexBasedArchitectureAnalysis
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(indexName="content", value=EIndexAccessMode.READ_ONLY)
    private TokenElementIndex contentIndex;
    @IndexAccess(indexName="content", value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private TokenElementIndex previousContentIndex;
    @DeltaSource(value=ArchitectureReferenceIndex.class)
    private KeyDelta changes;
    @IndexAccess(indexName="dependencies", value=EIndexAccessMode.READ_ONLY)
    private DependencyListIndex fileDependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeIndex typeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingsIndex findingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ArchitectureAssessmentIndex assessmentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingsSchemaIndex findingsSchemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex projectMetaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ArchitectureMappingIndex mappingIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ArchitectureFileDependenciesIndex architectureFileDependenciesIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ArchitectureTypeDependenciesIndex architectureTypeDependenciesIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ArchitectureComponentDependencyIndex componentDependencyIndex;
    private SetMap<String, String> typeDependencies;
    private SetMap<String, String> fileDependencies;
    public static final String ORPHANS_FINDING_GROUP = "Unmatched Types";
    public static final String ARCHITECTURE_ORPHANS_FINDINGS_PARTITION = "architecture-orphans";

    public void execute() throws StorageException, ExecutionException {
        ListMap<String, String> typeToFilesLookup = this.typeIndex.getTypeFileLookupMap();
        List<TokenElementInfo> architectureElements = this.contentIndex.getTokenElements(this.changes.getAddedOrChangedKeysAsStrings(), true);
        Set<ELanguage> projectLanguages = AnalysisProfileUtils.getConfiguredLanguages(this.projectMetaIndex);
        this.executeInParallelBatches(architectureElements, architecturesBatch -> {
            try {
                ArchitectureDefinition architectureDefinition = ArchitectureAnalysisUtils.getArchitectureDefinition((TokenElementInfo)((Object)((Object)Iterables.getOnlyElement((Iterable)architecturesBatch))));
                String architecturePath = architectureDefinition.getName();
                TypeComponentMapping architecture = this.mappingIndex.getMapping(architecturePath);
                if (architecture == null) {
                    return;
                }
                this.processArchitecture(architecturePath, architectureDefinition, typeToFilesLookup, architecture, projectLanguages);
            }
            catch (ConQATException e) {
                LOGGER.error(e.toString(), (Throwable)e);
            }
        }, 1);
    }

    private void processArchitecture(String architecturePath, ArchitectureDefinition architectureDefinition, ListMap<String, String> typeToFilesLookup, TypeComponentMapping architecture, Set<ELanguage> projectLanguages) throws ConQATException {
        List<DependencyValueClass> storedDependencies = this.componentDependencyIndex.getDependencies(architecturePath);
        List<Dependency> dependencies = ArchitectureAnalysisUtils.convertDependencyObjects(architectureDefinition, storedDependencies);
        this.performAssessment(architecturePath, architectureDefinition, typeToFilesLookup, architecture, dependencies, projectLanguages);
    }

    private void createFindings(String uniformPath, ITypeToFileLookup typeToFileLookup, ArchitectureDefinition annotatedArchitecture) throws AssertionError, ConQATException {
        IndexBase scopeIndex = annotatedArchitecture.isFileBased() ? this.architectureFileDependenciesIndex : this.architectureTypeDependenciesIndex;
        ArchitectureFindingCreator architectureFindingCreator = new ArchitectureFindingCreator(annotatedArchitecture, typeToFileLookup, (IArchitectureScopeIndex)scopeIndex);
        SetMap<String, IndexFinding> findings = architectureFindingCreator.createFindings();
        PairList findingValues = new PairList();
        for (String file : this.fileDependencyIndex.getAllUniformPaths()) {
            findingValues.add((Object)file, new ArrayList(findings.getCollectionOrEmpty((Object)file)));
        }
        this.findingsIndex.setFindings(uniformPath, findingValues, this.findingsSchemaIndex.getFindingsSchema());
    }

    private boolean canSkipFindingCreation(String uniformPath, ArchitectureDefinition annotatedArchitecture) throws ConQATException {
        if (annotatedArchitecture.getFindingCreation() == EFindingCreationType.NONE) {
            TokenElementInfo oldArchitectureText = this.previousContentIndex.getTokenElement(uniformPath);
            return oldArchitectureText == null || ArchitectureDefinitionReader.read(uniformPath, oldArchitectureText.getText()).getFindingCreation() == EFindingCreationType.NONE;
        }
        return false;
    }

    private synchronized SetMap<String, String> getOrCreateDependencies(ArchitectureDefinition architectureDefinition) throws StorageException {
        SetMap<String, String> dependencies;
        if (architectureDefinition.isFileBased()) {
            if (this.fileDependencies == null) {
                this.fileDependencies = this.architectureFileDependenciesIndex.getDependencies();
            }
            dependencies = this.fileDependencies;
        } else {
            if (this.typeDependencies == null) {
                this.typeDependencies = this.architectureTypeDependenciesIndex.getDependencies();
            }
            dependencies = this.typeDependencies;
        }
        return dependencies;
    }

    private void performAssessment(String architecturePath, ArchitectureDefinition architectureDefinition, ListMap<String, String> typeToFilesLookup, TypeComponentMapping architecture, List<Dependency> dependencyList, Set<ELanguage> projectLanguages) throws ConQATException, AssertionError {
        ArchitectureAnnotator annotator;
        if (architectureDefinition.getConstraints().isEmpty()) {
            annotator = new ArchitectureAnnotator(architectureDefinition, architecture, dependencyList);
        } else {
            SetMap<String, String> orCreateDependencies = this.getOrCreateDependencies(architectureDefinition);
            annotator = new ArchitectureAnnotator(architectureDefinition, architecture, dependencyList, orCreateDependencies);
        }
        annotator.assess();
        annotator.annotateArchitectureWithResult();
        ITypeToFileLookup typeToFileLookup = ITypeToFileLookup.create(architectureDefinition, typeToFilesLookup);
        boolean skipFindingCreation = this.canSkipFindingCreation(architecturePath, architectureDefinition);
        this.writeAssessment(architecturePath, architectureDefinition, typeToFileLookup, skipFindingCreation, projectLanguages);
        if (!skipFindingCreation) {
            this.createFindings(architecturePath, typeToFileLookup, architectureDefinition);
        }
    }

    private void writeAssessment(String uniformPath, ArchitectureDefinition annotatedArchitecture, ITypeToFileLookup typeToFileLookup, boolean skipFindingCreation, Set<ELanguage> projectLanguages) throws ConQATException {
        LOGGER.info("Writing architecture assessment for {}", (Object)uniformPath);
        ArchitectureAssessmentInfo architectureAssessment = ArchitectureAssessmentInfoUtils.convertToAssessmentInfo(annotatedArchitecture, typeToFileLookup, projectLanguages);
        this.assessmentIndex.setAssessment(uniformPath, architectureAssessment);
        if (!skipFindingCreation) {
            ArrayList<IndexFinding> orphanFindings = IndexBasedArchitectureAnalysis.createOrphanFindings(uniformPath, annotatedArchitecture);
            this.findingsIndex.setFindings(ARCHITECTURE_ORPHANS_FINDINGS_PARTITION, uniformPath, orphanFindings, this.findingsSchemaIndex.getFindingsSchema());
        }
    }

    private static ArrayList<IndexFinding> createOrphanFindings(String uniformPath, ArchitectureDefinition annotatedArchitecture) {
        ArrayList<IndexFinding> orphanFindings = new ArrayList<IndexFinding>();
        if (annotatedArchitecture.getFindingCreation() != EFindingCreationType.VIOLATIONS_ORPHANS) {
            return orphanFindings;
        }
        for (String orphan : annotatedArchitecture.getOrphans()) {
            IndexFinding finding = new IndexFinding(ORPHANS_FINDING_GROUP, "Architecture Conformance", "Unmatched type: `" + orphan + "`", new ElementLocation(uniformPath));
            orphanFindings.add(finding);
        }
        return orphanFindings;
    }
}

