/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.index.architecture.assessment.shared.Dependency;
import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import com.teamscale.index.architecture.commons.EAssessmentType;
import com.teamscale.index.architecture.commons.EPolicyType;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;

@IndexValueClass
public class DependencyValueClass
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String sourceComponentName;
    private final String targetComponentName;
    private final EPolicyType policyType;
    private final EAssessmentType assessmentType;
    private final Set<TypeDependency> dependencies;
    private final Set<TypeDependency> toleratedDependencies;

    public DependencyValueClass(Dependency dependency) {
        this.sourceComponentName = dependency.getSource().getName();
        this.targetComponentName = dependency.getTarget().getName();
        this.policyType = dependency.getType();
        this.assessmentType = dependency.getAssessment();
        this.dependencies = dependency.getTypeDependencies();
        this.toleratedDependencies = dependency.getToleratedDependencies();
    }

    @TestOnly
    public DependencyValueClass(String sourceComponentName, String targetComponentName, EPolicyType policyType, EAssessmentType assessmentType, Set<TypeDependency> dependencies, Set<TypeDependency> toleratedDependencies) {
        this.sourceComponentName = sourceComponentName;
        this.targetComponentName = targetComponentName;
        this.policyType = policyType;
        this.assessmentType = assessmentType;
        this.dependencies = dependencies;
        this.toleratedDependencies = toleratedDependencies;
    }

    public String getSourceComponentName() {
        return this.sourceComponentName;
    }

    public String getTargetComponentName() {
        return this.targetComponentName;
    }

    public EPolicyType getPolicyType() {
        return this.policyType;
    }

    public EAssessmentType getAssessmentType() {
        return this.assessmentType;
    }

    public Set<TypeDependency> getDependencies() {
        return this.dependencies;
    }

    public Set<TypeDependency> getToleratedDependencies() {
        return this.toleratedDependencies;
    }

    public void removeTypeDependencies(List<TypeDependency> dependenciesToRemove) {
        dependenciesToRemove.forEach(this.dependencies::remove);
    }
}

