/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.audit.checks;

import eu.cqse.check.base.JavaThrowExceptionCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(name="Throw of specific exception in Java", groupName="Exception Handling", defaultEnablement=EFindingEnablement.OFF, languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ThrowSpecificExceptionsJavaCheck
extends JavaThrowExceptionCheckBase {
    @CheckOption(name="Throw of specific exception: Method annotation filter", description="The check will be disabled if the method is annotated with one of these annotations (comma-separated list).")
    private Set<String> filteredMethodAnnotations = CollectionUtils.asHashSet((Object[])new String[]{"@Override", "@Test"});

    protected String getFindingMessage(List<IToken> tokens) {
        return "Throw of specific exception ";
    }

    public void initialize() {
        this.filteredMethodAnnotations = this.filteredMethodAnnotations.stream().map(String::trim).map(annotationName -> StringUtils.stripPrefix((String)annotationName, (String)"@")).collect(Collectors.toSet());
    }

    public boolean skipMethod(ShallowEntity entity) {
        List annotations = LanguageFeatureParser.JAVA.getAnnotations(entity);
        return annotations.stream().map(ShallowEntity::getName).anyMatch(this.filteredMethodAnnotations::contains);
    }

    public boolean createFindingForException(List<IToken> tokens, String exceptionClassName) {
        return !LanguageFeatureParser.JAVA.isGenericExceptionClass(exceptionClassName);
    }
}

