/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.backup.EBackupStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public abstract class BackupStatusBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="status")
    private EBackupStatus status = EBackupStatus.IN_PROGRESS;
    @JsonProperty(value="statusMessage")
    private String statusMessage;
    @JsonProperty(value="logs")
    private final List<LoggingEventTransport> logs = new ArrayList<LoggingEventTransport>();
    @JsonProperty(value="startDate")
    private final Date startDate;

    protected BackupStatusBase(String statusMessage) {
        this.statusMessage = statusMessage;
        this.startDate = Date.from(DateTimeUtils.now());
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.info(statusMessage);
        this.statusMessage = statusMessage;
    }

    public void setStatusAndMessage(EBackupStatus status, String statusMessage) {
        if (status == EBackupStatus.FAILURE) {
            this.error(statusMessage);
        } else {
            this.info(statusMessage);
        }
        this.status = status;
        this.statusMessage = statusMessage;
    }

    public EBackupStatus getStatus() {
        return this.status;
    }

    public void setStatus(EBackupStatus status) {
        this.status = status;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public List<LoggingEventTransport> getLogs() {
        return this.logs;
    }

    public void info(String message) {
        this.addLoggingEvent(message, ELogLevel.INFO);
    }

    public void error(String message) {
        this.addLoggingEvent(message, ELogLevel.ERROR);
    }

    private void addLoggingEvent(String message, ELogLevel logLevel) {
        this.logs.add(LoggingEventTransport.of((String)message, (ELogLevel)logLevel));
    }

    public abstract Optional<PublicProjectId> getSingleProjectId();
}

