/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.teamscale.index.backup.EBackupZipFileVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class MigratedZipFile
implements AutoCloseable {
    private final ZipFile delegate;
    private final List<EBackupZipFileVersion> backupFileVersions;

    public MigratedZipFile(ZipFile delegate, List<EBackupZipFileVersion> backupFileVersions) {
        this.delegate = delegate;
        this.backupFileVersions = backupFileVersions;
    }

    public Iterable<ZipArchiveEntry> getEntries() {
        return () -> new MigratingZipArchiveEntryIterator(this.delegate.getEntries());
    }

    public InputStream getInputStream(ZipArchiveEntry entry) throws IOException {
        return this.delegate.getInputStream(entry);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private ZipArchiveEntry migrateEntry(ZipArchiveEntry unmigratedEntry) {
        CCSMAssert.isNotNull((Object)unmigratedEntry, () -> String.format("Expected \"%s\" to be not null", "unmigratedEntry"));
        String unmigratedEntryName = unmigratedEntry.getName();
        String migratedEntryName = this.getMigratedPath(unmigratedEntryName);
        if (unmigratedEntryName.equals(migratedEntryName)) {
            return unmigratedEntry;
        }
        try {
            return new MigratedZipArchiveEntry(unmigratedEntry, migratedEntryName);
        }
        catch (ZipException e) {
            return (ZipArchiveEntry)CCSMAssert.fail((String)"Could not migrate entry from %s to %s".formatted(unmigratedEntryName, migratedEntryName), (Throwable)e);
        }
    }

    private String getMigratedPath(String unmigratedPath) {
        String migratedPath = unmigratedPath;
        for (EBackupZipFileVersion backupFileVersion : this.backupFileVersions) {
            migratedPath = backupFileVersion.migrate(migratedPath);
        }
        return migratedPath;
    }

    private static final class MigratedZipArchiveEntry
    extends ZipArchiveEntry {
        public MigratedZipArchiveEntry(ZipArchiveEntry entry, String migratedName) throws ZipException {
            super(entry);
            this.setName(migratedName);
        }
    }

    private class MigratingZipArchiveEntryIterator
    implements Iterator<ZipArchiveEntry> {
        private final Enumeration<ZipArchiveEntry> entries;

        public MigratingZipArchiveEntryIterator(Enumeration<ZipArchiveEntry> entries) {
            this.entries = entries;
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasMoreElements();
        }

        @Override
        public ZipArchiveEntry next() {
            return MigratedZipFile.this.migrateEntry(this.entries.nextElement());
        }
    }
}

