/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

@Index(name="temp-files", valueClasses={TemporaryFileDescriptor.class})
public class TemporaryFileIndex
extends IndexBase
implements IGlobalIndex {
    @VisibleForTesting
    static final int CHUNK_SIZE_BYTES = (int)ByteUnit.MEBIBYTES.toBytes(1L);
    private static final byte[] FILE_DESCRIPTOR_PREFIX = new byte[]{0};
    private static final byte[] VALUE_PREFIX = new byte[]{1};
    private static final String TEMPORARY_FILE_NAME_LOCK = "temp-file-lock";

    public TemporaryFileIndex(IStore store) {
        super(store);
    }

    public OutputStream writeFile(@NonNull String fileName) {
        CCSMAssert.isNotNull((Object)fileName, () -> String.format("Expected \"%s\" to be not null", "fileName"));
        return new TemporaryFileIndexOutputStream(fileName);
    }

    public InputStream readFile(@NonNull String fileName) throws StorageException {
        return this.getTemporaryFileIndexInputStream(fileName);
    }

    public SeekableByteChannel openReadChannel(@NonNull String fileName) throws StorageException {
        return this.getTemporaryFileIndexInputStream(fileName);
    }

    private @NonNull TemporaryFileIndexInputStream getTemporaryFileIndexInputStream(@NonNull String fileName) throws StorageException {
        CCSMAssert.isNotNull((Object)fileName, () -> String.format("Expected \"%s\" to be not null", "fileName"));
        long fileSize = this.getFileDescriptor(fileName).map(TemporaryFileDescriptor::exactSizeInBytes).orElseThrow(() -> new IllegalArgumentException("No file with name %s exists".formatted(fileName)));
        return new TemporaryFileIndexInputStream(fileName, fileSize);
    }

    public List<TemporaryFileDescriptor> listFiles() throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(FILE_DESCRIPTOR_PREFIX, (IKeyValueCallback)callback);
        return callback.getResultOrThrowException();
    }

    public Optional<TemporaryFileDescriptor> getFileDescriptor(@NonNull String fileName) throws StorageException {
        CCSMAssert.isNotNull((Object)fileName, () -> String.format("Expected \"%s\" to be not null", "fileName"));
        return Optional.ofNullable((TemporaryFileDescriptor)StorageUtils.deserialize((byte[])this.store.get(TemporaryFileIndex.makeFileDescriptorKey(fileName))));
    }

    public boolean fileExists(@NonNull String fileName) throws StorageException {
        CCSMAssert.isNotNull((Object)fileName, () -> String.format("Expected \"%s\" to be not null", "name"));
        return this.store.get(TemporaryFileIndex.makeFileDescriptorKey(fileName)) != null;
    }

    public String getTemporaryFileName() throws StorageException {
        Lock lock = this.store.obtainLock(TEMPORARY_FILE_NAME_LOCK);
        lock.lock();
        try {
            while (true) {
                String name;
                if (this.fileExists(name = UUID.randomUUID().toString())) continue;
                Instant creationTime = DateTimeUtils.now();
                this.storeFileDescriptor(new TemporaryFileDescriptor(name, creationTime, creationTime, 0L));
                String string = name;
                return string;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void deleteFile(@NonNull String fileName) throws StorageException {
        CCSMAssert.isNotNull((Object)fileName, () -> String.format("Expected \"%s\" to be not null", "fileName"));
        byte[] valuePrefix = ByteArrayUtils.concat((byte[][])new byte[][]{VALUE_PREFIX, StringUtils.stringToBytes((String)fileName)});
        List chunkContentKeys = CollectionUtils.filter((Collection)StorageUtils.listKeysStartingWith((byte[])valuePrefix, (IStore)this.store), key -> ((byte[])key).length == valuePrefix.length + 4);
        this.store.remove(chunkContentKeys);
        this.store.remove(TemporaryFileIndex.makeFileDescriptorKey(fileName));
    }

    private void storeFileDescriptor(TemporaryFileDescriptor fileDescriptor) throws StorageException {
        this.store.put(TemporaryFileIndex.makeFileDescriptorKey(fileDescriptor.fileName()), StorageUtils.serialize((Serializable)fileDescriptor));
    }

    private static byte[] makeFileDescriptorKey(String fileName) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{FILE_DESCRIPTOR_PREFIX, StringUtils.stringToBytes((String)fileName)});
    }

    private static byte[] makeChunkKey(String name, int chunk) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{VALUE_PREFIX, StringUtils.stringToBytes((String)name), ByteArrayUtils.intToByteArray((int)chunk)});
    }

    private final class TemporaryFileIndexOutputStream
    extends OutputStream {
        private final String name;
        private int chunk = 0;
        private final byte[] data = new byte[CHUNK_SIZE_BYTES];
        private int dataIndex = 0;
        private long totalBytesWritten = 0L;
        private final Instant creationTime = DateTimeUtils.now();

        private TemporaryFileIndexOutputStream(String name) {
            this.name = name;
        }

        @Override
        public void write(int b) throws IOException {
            this.data[this.dataIndex] = (byte)b;
            ++this.totalBytesWritten;
            ++this.dataIndex;
            if (this.dataIndex == CHUNK_SIZE_BYTES) {
                this.flush();
            }
        }

        @Override
        public void write(byte @NonNull [] input, int targetOffsetInInput, int length) throws IOException {
            int bytesToWrite;
            Objects.checkFromIndexSize(targetOffsetInInput, length, input.length);
            for (int remainingLength = length; remainingLength != 0; remainingLength -= bytesToWrite) {
                bytesToWrite = Math.min(remainingLength, this.data.length - this.dataIndex);
                System.arraycopy(input, targetOffsetInInput, this.data, this.dataIndex, bytesToWrite);
                targetOffsetInInput += bytesToWrite;
                this.totalBytesWritten += (long)bytesToWrite;
                this.dataIndex += bytesToWrite;
                if (this.dataIndex != CHUNK_SIZE_BYTES) continue;
                this.flush();
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.chunk == 0) {
                this.updateFileDescriptor();
            }
            if (this.dataIndex == 0) {
                return;
            }
            byte[] value = this.data;
            if (this.dataIndex < this.data.length) {
                value = Arrays.copyOf(this.data, this.dataIndex);
            }
            try {
                TemporaryFileIndex.this.store.put(TemporaryFileIndex.makeChunkKey(this.name, this.chunk), value);
            }
            catch (StorageException e) {
                throw new IOException(e);
            }
            if (this.dataIndex == this.data.length) {
                this.dataIndex = 0;
                ++this.chunk;
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.updateFileDescriptor();
        }

        private void updateFileDescriptor() throws IOException {
            try {
                TemporaryFileDescriptor updatedDescriptor = TemporaryFileIndex.this.getFileDescriptor(this.name).map(descriptor -> descriptor.withExactSizeInBytes(this.totalBytesWritten)).orElseGet(() -> new TemporaryFileDescriptor(this.name, this.creationTime, this.creationTime, this.totalBytesWritten));
                TemporaryFileIndex.this.storeFileDescriptor(updatedDescriptor);
            }
            catch (StorageException e) {
                throw new IOException(e);
            }
        }
    }

    private final class TemporaryFileIndexInputStream
    extends InputStream
    implements SeekableByteChannel {
        private final String name;
        private final long size;
        private int chunk = 0;
        private int indexInCurrentChunk = 0;
        private byte[] data;
        private final Deque<Position> marks = new ArrayDeque<Position>();

        private TemporaryFileIndexInputStream(String name, long size) {
            this.name = name;
            this.size = size;
        }

        @Override
        public synchronized void mark(int readLimit) {
            if (!this.isOpen()) {
                throw new IllegalStateException("Already closed");
            }
            this.marks.push(new Position(this.chunk, this.indexInCurrentChunk));
        }

        @Override
        public synchronized void reset() throws IOException {
            this.verifyOpen();
            if (this.marks.isEmpty()) {
                throw new IOException("no previous mark available");
            }
            Position mark = this.marks.pop();
            this.setPosition(mark);
        }

        private void setPosition(Position position) {
            if (this.chunk != position.chunk) {
                this.data = null;
            }
            this.chunk = position.chunk;
            this.indexInCurrentChunk = position.dataIndex;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() throws IOException {
            this.verifyOpen();
            if (this.hasNoData()) {
                this.loadChunk();
            }
            if (this.hasNoData()) {
                return -1;
            }
            if (this.indexInCurrentChunk >= CHUNK_SIZE_BYTES) {
                ++this.chunk;
                this.indexInCurrentChunk = 0;
                this.loadChunk();
                if (this.hasNoData()) {
                    return -1;
                }
            }
            if (this.indexInCurrentChunk >= this.data.length) {
                return -1;
            }
            return this.data[this.indexInCurrentChunk++] & 0xFF;
        }

        @Override
        public int read(byte @NonNull [] output, int targetOffsetInOutput, int length) throws IOException {
            Objects.checkFromIndexSize(targetOffsetInOutput, length, output.length);
            this.verifyOpen();
            if (this.hasNoData()) {
                this.loadChunk();
                if (this.hasNoData()) {
                    return -1;
                }
            }
            int remainingLength = length;
            int totalBytesRead = 0;
            do {
                int bytesToRead = Math.min(remainingLength, this.data.length - this.indexInCurrentChunk);
                System.arraycopy(this.data, this.indexInCurrentChunk, output, targetOffsetInOutput, bytesToRead);
                this.indexInCurrentChunk += bytesToRead;
                totalBytesRead += bytesToRead;
                targetOffsetInOutput += bytesToRead;
                remainingLength -= bytesToRead;
                if (this.indexInCurrentChunk < this.data.length) continue;
                ++this.chunk;
                this.indexInCurrentChunk = 0;
                this.loadChunk();
            } while (!this.hasNoData() && remainingLength != 0);
            return totalBytesRead;
        }

        private boolean hasNoData() {
            return this.data == null;
        }

        private void loadChunk() throws IOException {
            try {
                this.data = TemporaryFileIndex.this.store.get(TemporaryFileIndex.makeChunkKey(this.name, this.chunk));
                CCSMAssert.isFalse((this.data != null && this.data.length == 0 ? 1 : 0) != 0, (String)"empty chunks should never occur");
            }
            catch (StorageException e) {
                throw new IOException(e);
            }
        }

        @Override
        public int read(ByteBuffer destination) throws IOException {
            int totalRead;
            this.verifyOpen();
            int length = destination.remaining();
            int bytesRead = 0;
            byte[] buffer = new byte[]{};
            for (totalRead = 0; totalRead < length; totalRead += bytesRead) {
                int bytesToRead = Math.min(length - totalRead, CHUNK_SIZE_BYTES);
                if (buffer.length < bytesToRead) {
                    buffer = new byte[bytesToRead];
                }
                if ((bytesRead = this.read(buffer, 0, bytesToRead)) < 0) break;
                destination.put(buffer, 0, bytesRead);
            }
            if (bytesRead < 0 && totalRead == 0) {
                return -1;
            }
            return totalRead;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            throw new NonWritableChannelException();
        }

        @Override
        public long position() throws IOException {
            this.verifyOpen();
            return (long)CHUNK_SIZE_BYTES * (long)this.chunk + (long)this.indexInCurrentChunk;
        }

        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            this.verifyOpen();
            this.setPosition(Position.of(newPosition));
            return this;
        }

        @Override
        public long size() throws IOException {
            return this.size;
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            throw new NonWritableChannelException();
        }

        @Override
        public boolean isOpen() {
            return this.chunk >= 0;
        }

        private void verifyOpen() throws ClosedChannelException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
        }

        @Override
        public void close() throws IOException {
            this.updateFileDescriptorLastAccess();
            this.chunk = -1;
            this.data = null;
        }

        private void updateFileDescriptorLastAccess() throws IOException {
            try {
                Optional<TemporaryFileDescriptor> fileDescriptor = TemporaryFileIndex.this.getFileDescriptor(this.name);
                if (fileDescriptor.isPresent()) {
                    TemporaryFileIndex.this.storeFileDescriptor(fileDescriptor.get().withLastAccess(DateTimeUtils.now()));
                }
            }
            catch (StorageException e) {
                throw new IOException(e);
            }
        }

        private record Position(int chunk, int dataIndex) {
            static Position of(long position) {
                int chunk = (int)(position / (long)CHUNK_SIZE_BYTES);
                int dataIndex = (int)(position % (long)CHUNK_SIZE_BYTES);
                return new Position(chunk, dataIndex);
            }
        }
    }

    @IndexValueClass
    public record TemporaryFileDescriptor(@JsonProperty(value="fileName") @NonNull String fileName, @JsonProperty(value="creationTime") @NonNull Instant creationTime, @JsonProperty(value="lastAccessTime") @NonNull Instant lastAccessTime, @JsonProperty(value="exactSizeInBytes") long exactSizeInBytes) implements Serializable
    {
        public TemporaryFileDescriptor(@JsonProperty(value="fileName") @NonNull String fileName, @JsonProperty(value="creationTime") @NonNull Instant creationTime, @JsonProperty(value="lastAccessTime") @NonNull Instant lastAccessTime, @JsonProperty(value="exactSizeInBytes") long exactSizeInBytes) {
            CCSMAssert.isNotNull((Object)fileName, () -> String.format("Expected \"%s\" to be not null", "fileName"));
            CCSMAssert.isNotNull((Object)creationTime, () -> String.format("Expected \"%s\" to be not null", "creationTime"));
            CCSMAssert.isNotNull((Object)lastAccessTime, () -> String.format("Expected \"%s\" to be not null", "lastAccessTime"));
            if (lastAccessTime.isBefore(creationTime)) {
                throw new IllegalArgumentException("lastAccessTime (%s) must not be before creationTime (%s)".formatted(lastAccessTime, creationTime));
            }
        }

        private TemporaryFileDescriptor withLastAccess(Instant lastAccess) {
            return new TemporaryFileDescriptor(this.fileName, this.creationTime, lastAccess, this.exactSizeInBytes);
        }

        private TemporaryFileDescriptor withExactSizeInBytes(long exactSizeInBytes) {
            return new TemporaryFileDescriptor(this.fileName, this.creationTime, this.lastAccessTime, exactSizeInBytes);
        }
    }
}

