/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.read;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.crypto.EncryptedStorageHandler;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFile;
import org.conqat.lib.commons.string.StringUtils;

public class EncryptionAwareStoreImporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<String> encryptedEntryNames = new HashSet<String>();
    private SecretKeySpec decryptionKey;
    private final ZipFile backupFile;

    public EncryptionAwareStoreImporter(ZipFile backupFile) throws IOException {
        this.backupFile = backupFile;
        byte[] entryNameContent = EncryptionAwareStoreImporter.readEncryptedEntriesContent(backupFile);
        if (entryNameContent == null) {
            return;
        }
        for (SecretKeySpec keyCandidate : EncryptedStorageHandler.getAllKeys()) {
            try {
                String content = StringUtils.bytesToString((byte[])EncryptedStorageHandler.decrypt((byte[])entryNameContent, (SecretKeySpec)keyCandidate));
                if (content == null || !content.startsWith("Following stores have been encrypted:")) continue;
                this.decryptionKey = keyCandidate;
                List lines = StringUtils.splitLinesAsList((String)content);
                lines.remove(0);
                this.encryptedEntryNames.addAll(CollectionUtils.map((Collection)lines, String::trim));
                return;
            }
            catch (StorageException e) {
                LOGGER.debug((Object)e);
            }
        }
        throw new IOException("No key found that could decrypt the backup!");
    }

    private static byte[] readEncryptedEntriesContent(ZipFile backupFile) throws IOException {
        ZipArchiveEntry entry = backupFile.getEntry("Encrypted-Stores");
        if (entry == null) {
            return null;
        }
        try (InputStream inputStream = backupFile.getInputStream(entry);){
            byte[] byArray = FileSystemUtils.readStreamBinary((InputStream)inputStream);
            return byArray;
        }
    }

    public void importStore(ZipArchiveEntry entry, IStore store, ICancelable cancelable) throws StorageException, IOException, ExecutionCanceledException {
        try (InputStream stream = this.backupFile.getInputStream(entry);){
            if (this.encryptedEntryNames.contains(entry.getName())) {
                EncryptionAwareStoreImporter.importEncryptedStore(stream, store, this.decryptionKey, cancelable);
            } else {
                BufferedInputStream in = new BufferedInputStream(stream);
                DataInputStream din = new DataInputStream(in);
                if (EncryptionAwareStoreImporter.isLikelyEncrypted(in, din)) {
                    EncryptionAwareStoreImporter.importEncryptedStore(in, store, this.decryptionKey, cancelable);
                } else {
                    StorageUtils.importStore((IStore)store, (DataInputStream)din, (ICancelable)cancelable);
                }
            }
        }
    }

    private static void importEncryptedStore(InputStream in, IStore store, SecretKeySpec decryptionKey, ICancelable cancelable) throws IOException, StorageException, ExecutionCanceledException {
        byte[] data = FileSystemUtils.readStreamBinary((InputStream)in);
        byte[] decrypted = EncryptedStorageHandler.decrypt((byte[])data, (SecretKeySpec)decryptionKey);
        try (DataInputStream din = new DataInputStream(new ByteArrayInputStream(decrypted));){
            StorageUtils.importStore((IStore)store, (DataInputStream)din, (ICancelable)cancelable);
        }
    }

    public static boolean isLikelyEncrypted(BufferedInputStream in, DataInputStream din) throws IOException {
        in.mark(5);
        int firstKeySize = din.readInt();
        in.reset();
        return firstKeySize >= 0x1000000 || firstKeySize < -1;
    }

    public boolean isEncryptedName(String zipEntryName) {
        return this.encryptedEntryNames.contains(zipEntryName);
    }

    public SecretKeySpec getDecryptionKey() {
        return this.decryptionKey;
    }
}

