/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="finding-blacklist-commits", options={EStorageOption.COMPRESSED})
public class FindingBlacklistCommitsIndex
implements IProjectIndex,
IRollbackableIndex {
    private final ValueIndex<HashSet<CommitDescriptor>> delegate;

    public FindingBlacklistCommitsIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public Set<CommitDescriptor> getCommits(String findingId) throws StorageException {
        Set result = (Set)this.delegate.getValue(findingId);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    void addCommit(Collection<String> findingIds, CommitDescriptor commit) throws StorageException {
        for (String findingId : findingIds) {
            HashSet newCommits = Optional.ofNullable((HashSet)this.delegate.getValue(findingId)).orElseGet(HashSet::new);
            newCommits.add(new CommitDescriptor(commit));
            this.delegate.setValue(findingId, (Object)newCommits);
        }
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        List findingIds = this.delegate.getAllKeys();
        for (String findingId : findingIds) {
            HashSet commits = (HashSet)this.delegate.getValue(findingId, true);
            boolean modified = commits.removeIf(commit -> timestampByBranch.getOrDefault(commit.getBranchName(), Long.MAX_VALUE) < commit.getTimestamp());
            if (!modified) continue;
            this.delegate.setValue(findingId, (Object)commits);
        }
    }
}

