/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;

@IndexValueClass(containedInBackup=true)
public class FindingBlacklistInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FINDING_ID_PROPERTY = "findingId";
    private static final String TIMESTAMP_PROPERTY = "timestamp";
    private static final String USER_PROPERTY = "user";
    private static final String RATIONALE_PROPERTY = "rationale";
    private static final String TYPE_PROPERTY = "type";
    private static final String APPROVAL_STATE_PROPERTY = "approvalState";
    @JsonProperty(value="findingId")
    private final String findingId;
    @JsonProperty(value="timestamp")
    private final long timestamp;
    @JsonProperty(value="user")
    private final String user;
    @JsonProperty(value="rationale")
    private final String rationale;
    @JsonProperty(value="type")
    private final EFindingBlacklistType type;
    @JsonProperty(value="approvalState")
    private final IApprovalState approvalState;

    public FindingBlacklistInfo(FindingBlacklistInfo info) {
        this.findingId = info.findingId;
        this.timestamp = info.timestamp;
        this.user = info.user;
        this.rationale = info.rationale;
        this.type = info.type;
        this.approvalState = info.approvalState;
    }

    @JsonCreator
    public FindingBlacklistInfo(@JsonProperty(value="findingId") String findingId, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="user") String user, @JsonProperty(value="rationale") String rationale, @JsonProperty(value="type") EFindingBlacklistType type, @JsonProperty(value="approvalState") IApprovalState approvalState) {
        this.findingId = Objects.requireNonNull(findingId, FINDING_ID_PROPERTY);
        this.timestamp = timestamp;
        this.user = Objects.requireNonNull(user, USER_PROPERTY);
        this.rationale = Objects.requireNonNullElse(rationale, "");
        this.type = Objects.requireNonNull(type, TYPE_PROPERTY);
        this.approvalState = Objects.requireNonNull(approvalState, APPROVAL_STATE_PROPERTY);
    }

    @TestOnly
    public static FindingBlacklistInfo approved(String findingId, long timestamp, String user, String rationale, EFindingBlacklistType type) {
        return new FindingBlacklistInfo(findingId, timestamp, user, rationale, type, new IApprovalState.Approved(user, timestamp, null));
    }

    public FindingBlacklistInfo cloneWithApproval(String approvedBy, long approvedAt, String rationale) {
        if (!(this.approvalState instanceof IApprovalState.Pending)) {
            throw new IllegalStateException("Not in %s state".formatted(IApprovalState.Pending.class.getSimpleName()));
        }
        return new FindingBlacklistInfo(this.findingId, this.timestamp, this.user, this.rationale, this.type, new IApprovalState.Approved(approvedBy, approvedAt, rationale));
    }

    public FindingBlacklistInfo cloneWithRejection(String rejectedBy, long rejectedAt, String rationale) {
        if (!(this.approvalState instanceof IApprovalState.Pending)) {
            throw new IllegalStateException("Not in %s state".formatted(IApprovalState.Pending.class.getSimpleName()));
        }
        return new FindingBlacklistInfo(this.findingId, this.timestamp, this.user, this.rationale, this.type, new IApprovalState.Rejected(rejectedBy, rejectedAt, rationale));
    }

    public String getFindingId() {
        return this.findingId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUser() {
        return this.user;
    }

    public String getRationale() {
        return this.rationale;
    }

    public EFindingBlacklistType getType() {
        return this.type;
    }

    public IApprovalState getApprovalState() {
        return this.approvalState;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof FindingBlacklistInfo) {
            FindingBlacklistInfo other = (FindingBlacklistInfo)obj;
            return Objects.equals(this.findingId, other.findingId) && Objects.equals(this.rationale, other.rationale) && this.timestamp == other.timestamp && Objects.equals(this.user, other.user) && this.type == other.type && Objects.equals(this.approvalState, other.approvalState);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.findingId, this.rationale, this.timestamp, this.user, this.type, this.approvalState});
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    private Object readResolve() throws ObjectStreamException {
        EFindingBlacklistType patchedType = FindingBlacklistInfo.patchType(this);
        IApprovalState patchApprovalState = FindingBlacklistInfo.patchApprovalState(this);
        return new FindingBlacklistInfo(this.findingId, this.timestamp, this.user, this.rationale, patchedType, patchApprovalState);
    }

    private static EFindingBlacklistType patchType(FindingBlacklistInfo info) {
        if (info.type != null) {
            return info.type;
        }
        return FindingBlacklistInfo.resolveType(info.rationale);
    }

    private static EFindingBlacklistType resolveType(String rationale) {
        if (!StringUtils.isEmpty((String)rationale) && rationale.toLowerCase().contains("false") && rationale.toLowerCase().contains("positive")) {
            return EFindingBlacklistType.FALSE_POSITIVE;
        }
        return EFindingBlacklistType.TOLERATION;
    }

    private static IApprovalState patchApprovalState(FindingBlacklistInfo info) {
        if (info.approvalState != null) {
            return info.approvalState;
        }
        return new IApprovalState.Approved(info.user, info.timestamp, null);
    }

    @IndexValueClass(containedInBackup=true)
    @Schema(oneOf={Pending.class, IResolvedState.class})
    public static sealed interface IApprovalState
    extends Serializable {
        @JsonGetter
        public boolean resolved();

        @JsonCreator
        public static IApprovalState fromJson(JsonNode jsonNode) {
            if (jsonNode.get("resolved").booleanValue()) {
                return IResolvedState.fromJson(jsonNode);
            }
            return Pending.fromJson(jsonNode);
        }

        @IndexValueClass(containedInBackup=true)
        @Schema(oneOf={Approved.class, Rejected.class})
        public static sealed interface IResolvedState
        extends IApprovalState
        permits Approved, Rejected {
            @JsonGetter
            public boolean approved();

            @Override
            @Schema(extensions={@Extension(name="x-Teamscale", properties={@ExtensionProperty(name="type", value="true")})})
            default public boolean resolved() {
                return true;
            }

            @JsonGetter
            public String by();

            @JsonGetter
            public long at();

            @JsonGetter
            public String rationale();

            @JsonCreator
            public static IResolvedState fromJson(JsonNode jsonNode) {
                if (jsonNode.get("approved").booleanValue()) {
                    return Approved.fromJson(jsonNode);
                }
                return Rejected.fromJson(jsonNode);
            }
        }

        @IndexValueClass(containedInBackup=true)
        public record Pending() implements IApprovalState
        {
            @JsonCreator
            static Pending fromJson(JsonNode jsonNode) {
                return new Pending();
            }

            @Override
            @Schema(extensions={@Extension(name="x-Teamscale", properties={@ExtensionProperty(name="type", value="false")})})
            public boolean resolved() {
                return false;
            }
        }

        @IndexValueClass(containedInBackup=true)
        public record Rejected(String by, long at, String rationale) implements IResolvedState
        {
            public Rejected {
                Objects.requireNonNull(by, "by");
                if (at <= 0L) {
                    throw new IllegalArgumentException("at must be greater than 0");
                }
                rationale = Objects.requireNonNullElse(rationale, "");
            }

            @JsonCreator
            static Rejected fromJson(JsonNode jsonNode) {
                return new Rejected(jsonNode.get("by").textValue(), jsonNode.get("at").longValue(), jsonNode.get(FindingBlacklistInfo.RATIONALE_PROPERTY).textValue());
            }

            @Override
            @Schema(extensions={@Extension(name="x-Teamscale", properties={@ExtensionProperty(name="type", value="false")})})
            public boolean approved() {
                return false;
            }
        }

        @IndexValueClass(containedInBackup=true)
        public record Approved(String by, long at, String rationale) implements IResolvedState
        {
            public Approved {
                Objects.requireNonNull(by, "by");
                if (at <= 0L) {
                    throw new IllegalArgumentException("at must be greater than 0");
                }
                rationale = Objects.requireNonNullElse(rationale, "");
            }

            @JsonCreator
            static Approved fromJson(JsonNode jsonNode) {
                return new Approved(jsonNode.get("by").textValue(), jsonNode.get("at").longValue(), jsonNode.get(FindingBlacklistInfo.RATIONALE_PROPERTY).textValue());
            }

            @Override
            @Schema(extensions={@Extension(name="x-Teamscale", properties={@ExtensionProperty(name="type", value="true")})})
            public boolean approved() {
                return true;
            }
        }
    }
}

