/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.check;

import eu.cqse.check.framework.core.CheckInstance;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class CheckOptionStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TwoDimHashMap<String, String, Object> entries = new TwoDimHashMap();

    public <T> void putValue(String checkIdentifier, String optionName, Object value, Class<T> type) {
        if (value == null) {
            return;
        }
        Object castedValue = CCSMAssert.checkedCast((Object)value, type);
        this.entries.putValue((Object)checkIdentifier, (Object)optionName, castedValue);
    }

    public String serializeToBase64String() {
        try {
            return Base64.encodeBase64String((byte[])StorageUtils.serialize((Serializable)this));
        }
        catch (StorageException e) {
            throw new AssertionError("Serializing to string failed: " + e.getMessage(), e);
        }
    }

    public static CheckOptionStore deserializeFromBase64String(String hex) {
        byte[] serialized = Base64.decodeBase64((String)hex);
        try {
            return (CheckOptionStore)StorageUtils.deserialize((byte[])serialized);
        }
        catch (StorageException e) {
            throw new AssertionError("Deserializing from string failed: " + e.getMessage(), e);
        }
    }

    public void applyCheckOptions(CheckInstance check) {
        if (check.getCheckInfo().getOptions().isEmpty()) {
            return;
        }
        UnmodifiableMap checkOptions = this.entries.getSecondMap((Object)check.getCheckInfo().getIdentifier());
        if (checkOptions != null) {
            checkOptions.forEach((arg_0, arg_1) -> ((CheckInstance)check).setOption(arg_0, arg_1));
        }
    }
}

