/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change;

import com.teamscale.index.baseline.BaselineIndex;
import jakarta.ws.rs.BadRequestException;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;
import org.conqat.engine.index.baseline.BaselineInfo;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public final class UnresolvedBaseline
implements Serializable {
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("^-?\\d+$");
    public static final long TIMESTAMP_NO_BASELINE = -1L;
    private static final long serialVersionUID = 1L;
    private final long timestamp;
    private final String baselineName;

    private UnresolvedBaseline(long timestamp) {
        this.timestamp = timestamp;
        this.baselineName = null;
    }

    private UnresolvedBaseline(String baselineName) {
        this.timestamp = -1L;
        this.baselineName = baselineName;
    }

    private boolean isNamedBaseline() {
        return this.baselineName != null;
    }

    public String toString() {
        if (this.isNamedBaseline()) {
            return this.baselineName;
        }
        return Long.toString(this.timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnresolvedBaseline that = (UnresolvedBaseline)o;
        return this.timestamp == that.timestamp && Objects.equals(this.baselineName, that.baselineName);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.baselineName);
    }

    public long resolve(ProjectStorageSystem projectStorageSystem) throws StorageException {
        if (!this.isNamedBaseline()) {
            return this.timestamp;
        }
        BaselineIndex baselineIndex = (BaselineIndex)projectStorageSystem.openProjectIndex(BaselineIndex.class, null);
        BaselineInfo baseline = baselineIndex.getBaseline(this.baselineName);
        if (baseline == null) {
            throw new BadRequestException("No such baseline: " + this.baselineName);
        }
        return baseline.getTimestamp();
    }

    public static UnresolvedBaseline parse(String baseline) {
        if (StringUtils.isEmpty((String)baseline)) {
            return new UnresolvedBaseline(-1L);
        }
        if (TIMESTAMP_PATTERN.matcher(baseline).matches()) {
            if (baseline.startsWith("-")) {
                return new UnresolvedBaseline(-1L);
            }
            return new UnresolvedBaseline(Long.parseLong(baseline));
        }
        return new UnresolvedBaseline(baseline);
    }
}

