/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change.refactoring_detection;

import com.teamscale.index.code_change.refactoring_detection.ELocalRefactoringDetectionResult;
import com.teamscale.index.code_change.refactoring_detection.MethodRefactoringDetectionUtils;
import com.teamscale.index.code_change.refactoring_detection.MethodRefactoringDetectorStrategyBase;
import com.teamscale.index.code_change.refactoring_detection.NumberLiteralCasingChangeDetector;
import com.teamscale.index.code_change.refactoring_detection.ParallelTokenListIterator;
import com.teamscale.index.code_change.refactoring_detection.RenameDetector;
import com.teamscale.index.code_change.refactoring_detection.java.ThisKeywordInsertionDetector;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class CLikeMethodRefactoringDetectorStrategyBase
extends MethodRefactoringDetectorStrategyBase {
    protected Map<TypedVariable, List<IToken>> extractedVariablesCandidates = new HashMap<TypedVariable, List<IToken>>();
    protected Set<TypedVariable> actualExtractions = new HashSet<TypedVariable>();

    public CLikeMethodRefactoringDetectorStrategyBase(ELanguage language, RenameDetector renameDetector) {
        super(language, renameDetector);
        this.detectors.add(new NumberLiteralCasingChangeDetector());
        this.detectors.add(new ThisKeywordInsertionDetector());
    }

    @Override
    protected boolean childrenDeltaContainsRefactoringsOnly(Diff.Delta<ShallowEntity> delta) {
        return this.deltaEmptyAfterVariableExtraction(delta);
    }

    private boolean deltaEmptyAfterVariableExtraction(Diff.Delta<ShallowEntity> delta) {
        PairList modifiedStatements = new PairList();
        PairList addedStatements = new PairList();
        MethodRefactoringDetectionUtils.filterAddedAndModifiedLinesFromDelta(delta, (PairList<ShallowEntity, Boolean>)addedStatements, (PairList<ShallowEntity, ShallowEntity>)modifiedStatements);
        Map<TypedVariable, List<IToken>> extractedVariablesInScope = this.getVariableExtractions((PairList<ShallowEntity, Boolean>)addedStatements);
        if (extractedVariablesInScope == null) {
            return false;
        }
        boolean isUnchanged = true;
        this.extractedVariablesCandidates.putAll(extractedVariablesInScope);
        for (Pair pair : modifiedStatements) {
            if (this.entitiesEqual((ShallowEntity)pair.getFirst(), (ShallowEntity)pair.getSecond())) continue;
            isUnchanged = false;
            break;
        }
        isUnchanged = isUnchanged && this.actualExtractions.containsAll(extractedVariablesInScope.keySet());
        for (TypedVariable extractedVariable : extractedVariablesInScope.keySet()) {
            this.extractedVariablesCandidates.remove(extractedVariable);
        }
        return isUnchanged;
    }

    private Map<TypedVariable, List<IToken>> getVariableExtractions(PairList<ShallowEntity, Boolean> addedOrRemovedEntries) {
        HashMap<TypedVariable, List<IToken>> extractedVariablesInScope = new HashMap<TypedVariable, List<IToken>>();
        for (Pair addedOrRemovedEntry : addedOrRemovedEntries) {
            ShallowEntity entity = (ShallowEntity)addedOrRemovedEntry.getFirst();
            if (entity.getType() != EShallowEntityType.STATEMENT || !entity.getSubtype().equals("local variable")) {
                return null;
            }
            List<IToken> extractedExpression = CLikeMethodRefactoringDetectorStrategyBase.getAssignmentRightHandSide(entity);
            Boolean removed = (Boolean)addedOrRemovedEntry.getSecond();
            ITypeResolution typeResolution = removed != false ? this.oldTypeResolution : this.newTypeResolution;
            TypedVariable extractedVariable = typeResolution.getTypeLookup(entity).getTypeInfo(entity.getName());
            extractedVariablesInScope.put(extractedVariable, extractedExpression);
        }
        return extractedVariablesInScope;
    }

    private static List<IToken> getAssignmentRightHandSide(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        int index = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.EQ);
        if (index == -1 || index == tokens.size() - 1) {
            return null;
        }
        return tokens.subList(index + 1, tokens.size() - 1);
    }

    @Override
    protected boolean areOwnStartAndEndTokensEqual(ShallowEntity oldEntity, ShallowEntity newEntity) {
        List oldOwnStartTokens = TokenStreamUtils.removeAtEnd((List)oldEntity.ownStartTokens(), (ETokenType)ETokenType.LBRACE);
        List newOwnStartTokens = TokenStreamUtils.removeAtEnd((List)newEntity.ownStartTokens(), (ETokenType)ETokenType.LBRACE);
        List oldOwnEndTokens = TokenStreamUtils.removeAtFront((List)oldEntity.ownEndTokens(), (ETokenType)ETokenType.RBRACE);
        List newOwnEndTokens = TokenStreamUtils.removeAtFront((List)newEntity.ownEndTokens(), (ETokenType)ETokenType.RBRACE);
        return this.areStatementsEqual(oldEntity, oldOwnStartTokens, newEntity, newOwnStartTokens) && this.areStatementsEqual(oldEntity, oldOwnEndTokens, newEntity, newOwnEndTokens);
    }

    @Override
    protected ELocalRefactoringDetectionResult detectVariableRename(ParallelTokenListIterator tokenListIterator) {
        if (this.getRenameableTokenTypes().contains(tokenListIterator.getOldTokenListIterator().getCurrentToken().getType()) || this.getRenameableTokenTypes().contains(tokenListIterator.getNewTokenListIterator().getCurrentToken().getType())) {
            TypedVariable oldVariable = tokenListIterator.getOldTypeInfo(tokenListIterator.getOldTokenText());
            TypedVariable newVariable = tokenListIterator.getNewTypeInfo(tokenListIterator.getNewTokenText());
            if (this.extractedVariablesCandidates.get(oldVariable) != null && tokenListIterator.newEquals(this.extractedVariablesCandidates.get(oldVariable))) {
                tokenListIterator.next();
                this.actualExtractions.add(oldVariable);
                return ELocalRefactoringDetectionResult.REFACTORING;
            }
            if (this.extractedVariablesCandidates.get(newVariable) != null && tokenListIterator.oldEquals(this.extractedVariablesCandidates.get(newVariable))) {
                tokenListIterator.next();
                this.actualExtractions.add(newVariable);
                return ELocalRefactoringDetectionResult.REFACTORING;
            }
            return super.detectVariableRename(tokenListIterator, oldVariable, newVariable);
        }
        return ELocalRefactoringDetectionResult.NO_DECISION;
    }

    @Override
    protected boolean isMethodInvocation(ParallelTokenListIterator parallelTokenListIterator) {
        return parallelTokenListIterator.bothMatchTypeSequence(0, ETokenType.IDENTIFIER, ETokenType.LPAREN);
    }
}

