/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change.refactoring_detection;

import com.teamscale.index.code_change.MatchRegion;
import com.teamscale.index.code_change.refactoring_detection.IRefactoringDetectorStrategy;
import com.teamscale.index.code_change.refactoring_detection.RenameDetector;
import com.teamscale.index.code_change.refactoring_detection.abap.AbapMethodRefactoringDetectorStrategy;
import com.teamscale.index.code_change.refactoring_detection.c_cpp.CppAndCMethodRefactoringDetectorStrategy;
import com.teamscale.index.code_change.refactoring_detection.cs.CsMethodRefactoringDetectorStrategy;
import com.teamscale.index.code_change.refactoring_detection.java.JavaMethodRefactoringDetectorStrategy;
import com.teamscale.index.code_change.refactoring_detection.other.CommentFilteringOnlyRefectoringDetector;
import eu.cqse.check.framework.scanner.ELanguage;

public class RefactoringDetectorStrategyFactory {
    public static IRefactoringDetectorStrategy<? extends MatchRegion> createRefactoringDetectorStrategy(ELanguage language, RenameDetector renameDetector) {
        return switch (language) {
            case ELanguage.ABAP -> new AbapMethodRefactoringDetectorStrategy(renameDetector);
            case ELanguage.CS -> new CsMethodRefactoringDetectorStrategy(renameDetector);
            case ELanguage.JAVA -> new JavaMethodRefactoringDetectorStrategy(renameDetector);
            case ELanguage.CPP -> new CppAndCMethodRefactoringDetectorStrategy(ELanguage.CPP, renameDetector);
            case ELanguage.CPP_MS_CLI -> new CppAndCMethodRefactoringDetectorStrategy(ELanguage.CPP_MS_CLI, renameDetector);
            case ELanguage.C -> new CppAndCMethodRefactoringDetectorStrategy(ELanguage.C, renameDetector);
            default -> new CommentFilteringOnlyRefectoringDetector();
        };
    }
}

