/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.teamscale.index.code_clones.CloneChunkIndexBase;
import com.teamscale.index.code_clones.detection.CloneChunk;
import com.teamscale.index.code_clones.detection.CloneChunkList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="clone-chunks-by-hash", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={CloneChunk.class})
public class CloneChunkByHashIndex
extends CloneChunkIndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "clone-chunks-by-hash";

    public CloneChunkByHashIndex(IStore store) {
        super(store);
    }

    public List<CloneChunkList> getChunksForHashes(List<Long> hashes) throws StorageException {
        ArrayList<CloneChunkList> result = new ArrayList<CloneChunkList>();
        List keys = CollectionUtils.map(hashes, ByteArrayUtils::longToByteArray);
        List values = this.store.get(keys);
        for (int i = 0; i < hashes.size(); ++i) {
            if (values.get(i) == null) {
                result.add(new CloneChunkList());
                continue;
            }
            result.add(CloneChunkByHashIndex.decompressChunks((byte[])values.get(i), null, this.store.getAbbreviator(), hashes.get(i)));
        }
        return result;
    }

    public void insertChunksByHash(List<Long> hashes, List<? extends List<CloneChunk>> chunksByHash) throws StorageException {
        CCSMAssert.isTrue((hashes.size() == chunksByHash.size() ? 1 : 0) != 0, (String)"Both input lists must have same length!");
        PairList keysValues = new PairList();
        for (int i = 0; i < hashes.size(); ++i) {
            List sortedHashes = CollectionUtils.sort((Collection)chunksByHash.get(i), CloneChunk.CHUNK_COMPARATOR);
            keysValues.add((Object)ByteArrayUtils.longToByteArray((long)hashes.get(i)), (Object)CloneChunkByHashIndex.compressChunks(sortedHashes, this.store.getAbbreviator(), false));
        }
        this.store.put(keysValues);
    }
}

