/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.teamscale.index.code_clones.detection.CloneChunk;
import com.teamscale.index.code_clones.detection.CloneChunkList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

public abstract class CloneChunkIndexBase
extends IndexBase {
    protected CloneChunkIndexBase(IStore store) {
        super(store);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static byte[] compressChunks(List<CloneChunk> chunks, @Nullable StorageStringAbbreviator originAbbreviator, boolean includeHash) throws StorageException {
        boolean compactFormat = CloneChunkIndexBase.canUseCompact(chunks);
        Map originAbbreviationMap = null;
        if (originAbbreviator != null) {
            originAbbreviationMap = originAbbreviator.buildAbbreviationMap(CollectionUtils.mapToSet(chunks, CloneChunk::getOriginId));
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeBoolean(compactFormat);
                for (CloneChunk chunk : chunks) {
                    CloneChunkIndexBase.writeChunk(chunk, dos, compactFormat, originAbbreviationMap, includeHash);
                }
                object = bos.toByteArray();
            }
            return object;
        }
        catch (IOException e) {
            throw new AssertionError("Should not be possible as we are writing to memory!", e);
        }
    }

    private static boolean canUseCompact(List<CloneChunk> chunks) {
        for (CloneChunk chunk : chunks) {
            if (chunk.getRawEndOffset() < Short.MAX_VALUE && chunk.getElementUnits() < Short.MAX_VALUE) continue;
            return false;
        }
        return true;
    }

    private static void writeChunk(CloneChunk chunk, DataOutputStream dos, boolean compactFormat, Map<String, Integer> originAbbreviationMap, boolean includeHash) throws IOException {
        if (originAbbreviationMap != null) {
            dos.writeInt(originAbbreviationMap.get(chunk.getOriginId()));
        }
        if (includeHash) {
            dos.writeLong(chunk.getChunkHash());
        }
        if (compactFormat) {
            dos.writeShort(chunk.getFirstUnitIndex());
            dos.writeShort(chunk.getFirstRawLineNumber());
            dos.writeShort(chunk.getLastRawLineNumber());
            dos.writeShort(chunk.getRawStartOffset());
            dos.writeShort(chunk.getRawEndOffset());
            dos.writeShort(chunk.getElementUnits());
        } else {
            dos.writeInt(chunk.getFirstUnitIndex());
            dos.writeInt(chunk.getFirstRawLineNumber());
            dos.writeInt(chunk.getLastRawLineNumber());
            dos.writeInt(chunk.getRawStartOffset());
            dos.writeInt(chunk.getRawEndOffset());
            dos.writeInt(chunk.getElementUnits());
        }
    }

    protected static CloneChunkList decompressChunks(byte[] data, @Nullable String originId, @Nullable StorageStringAbbreviator originAbbreviator, @Nullable Long chunkHash) throws StorageException {
        CloneChunkList cloneChunkList;
        if (originId == null && originAbbreviator == null) {
            throw new AssertionError((Object)"Either originId or originAbbreviator must be non-null!");
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        try {
            boolean compactFormat = dis.readBoolean();
            CloneChunkList result = new CloneChunkList();
            while (dis.available() > 0) {
                result.add(CloneChunkIndexBase.readChunk(dis, originId, originAbbreviator, chunkHash, compactFormat));
            }
            cloneChunkList = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new StorageException("Should not happen, as operates in memory!", (Throwable)e);
            }
        }
        dis.close();
        return cloneChunkList;
    }

    private static CloneChunk readChunk(DataInputStream dis, @Nullable String originId, @Nullable StorageStringAbbreviator originAbbreviator, @Nullable Long chunkHash, boolean compactFormat) throws IOException, StorageException {
        if (originId == null) {
            originId = originAbbreviator.unabbreviate(dis.readInt());
        }
        if (chunkHash == null) {
            chunkHash = dis.readLong();
        }
        if (compactFormat) {
            return new CloneChunk(originId, chunkHash, dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort());
        }
        return new CloneChunk(originId, chunkHash, dis.readInt(), dis.readInt(), dis.readInt(), dis.readInt(), dis.readInt(), dis.readInt());
    }
}

